/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.workflow.timeout.autoadvance;

import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.exec.Route;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.job.AbsoluteTimeoutHandler;
import com.day.cq.workflow.metadata.MetaDataMap;
import com.day.cq.workflow.model.WorkflowTransition;
import com.day.cq.workflow.timeout.autoadvance.AutoAdvancer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbsoluteTimeAutoAdvancer
extends AutoAdvancer
implements AbsoluteTimeoutHandler {
    protected final Logger log = LoggerFactory.getLogger(AbsoluteTimeAutoAdvancer.class);

    public void execute(WorkItem item, WorkflowSession session, MetaDataMap args) throws WorkflowException {
        try {
            boolean advanced = false;
            List routes = session.getRoutes(item);
            for (Route route : routes) {
                if (!route.hasDefault()) continue;
                String fromTitle = item.getNode().getTitle();
                String toTitle = ((WorkflowTransition)route.getDestinations().get(0)).getTo().getTitle();
                session.complete(item, route);
                this.log.debug(item.getId() + " advanced from " + fromTitle + " to " + toTitle);
                advanced = true;
            }
            if (!advanced) {
                session.complete(item, (Route)routes.get(0));
                String fromTitle = item.getNode().getTitle();
                String toTitle = ((WorkflowTransition)((Route)routes.get(0)).getDestinations().get(0)).getTo().getTitle();
                this.log.debug(item.getId() + " advanced from " + fromTitle + " to " + toTitle);
            }
        }
        catch (WorkflowException e) {
            this.log.error("Could not advance workflow.", (Throwable)e);
        }
    }

    public long getTimeoutDate(WorkItem workItem) {
        Long date = (Long)workItem.getWorkflowData().getMetaDataMap().get("absoluteTime", Long.class);
        return date != null ? date : -1L;
    }
}

