/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.workflow.ui.impl;

import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.ui.JcrPathBuilderManager;
import com.day.cq.workflow.ui.JcrPayloadPathBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrPathBuilderManagerImpl
implements JcrPathBuilderManager {
    protected final Logger log = LoggerFactory.getLogger(JcrPathBuilderManagerImpl.class);
    Map<Object, JcrPayloadPathBuilder> jcrPayloadPathBuilder = new TreeMap<Object, JcrPayloadPathBuilder>();
    JcrPayloadPathBuilder defaultBuilder = new DefaultJcrPayloadPathBuilder();
    protected BundleContext bundleContext;
    protected List<ServiceReference> registeredBuilderReferences = new ArrayList<ServiceReference>();
    private Integer currentDefaultRanking = 0;

    public String getPath(WorkItem workItem) {
        for (JcrPayloadPathBuilder builder : this.jcrPayloadPathBuilder.values()) {
            if (builder.buildPath(workItem) == null) continue;
            return builder.buildPath(workItem);
        }
        return this.defaultBuilder.buildPath(workItem);
    }

    protected void activate(ComponentContext componentContext) {
        this.bundleContext = componentContext.getBundleContext();
        for (ServiceReference ref : this.registeredBuilderReferences) {
            JcrPayloadPathBuilder pb = (JcrPayloadPathBuilder)this.bundleContext.getService(ref);
            if (pb == null) continue;
            this.addBuilder(pb, this.getServiceRanking(ref));
        }
        this.registeredBuilderReferences.clear();
    }

    protected void deactivate(ComponentContext componentContext) {
        this.bundleContext = null;
    }

    protected void bindPathBuilderRef(ServiceReference ref) {
        if (this.bundleContext == null) {
            this.registeredBuilderReferences.add(ref);
        } else {
            JcrPayloadPathBuilder pb = (JcrPayloadPathBuilder)this.bundleContext.getService(ref);
            if (pb != null) {
                this.addBuilder(pb, this.getServiceRanking(ref));
            }
        }
    }

    protected void unbindPathBuilderRef(ServiceReference ref) {
        if (this.bundleContext != null) {
            JcrPayloadPathBuilder pb = (JcrPayloadPathBuilder)this.bundleContext.getService(ref);
            this.removeBuilder(pb);
        }
    }

    private Object getServiceRanking(ServiceReference ref) {
        return ref.getProperty("service.ranking");
    }

    private void addBuilder(JcrPayloadPathBuilder pb, Object serviceRanking) {
        if (serviceRanking == null) {
            Integer n = this.currentDefaultRanking;
            Integer n2 = this.currentDefaultRanking = Integer.valueOf(this.currentDefaultRanking + 1);
            this.jcrPayloadPathBuilder.put(n, pb);
        } else {
            this.jcrPayloadPathBuilder.put(serviceRanking, pb);
        }
    }

    private void removeBuilder(JcrPayloadPathBuilder pb) {
        for (Object key : this.jcrPayloadPathBuilder.keySet()) {
            JcrPayloadPathBuilder jpb = this.jcrPayloadPathBuilder.get(key);
            if (!jpb.getClass().getName().equals(pb.getClass().getName())) continue;
            this.jcrPayloadPathBuilder.remove(key);
            break;
        }
    }

    public class DefaultJcrPayloadPathBuilder
    implements JcrPayloadPathBuilder {
        public String buildPath(WorkItem workItem) {
            return workItem.getWorkflowData().getPayload().toString();
        }
    }
}

