/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.workflow.filter;

import com.day.cq.security.Authorizable;
import com.day.cq.security.UserManager;
import com.day.cq.workflow.exec.WorkItem;
import com.day.cq.workflow.exec.filter.WorkItemFilter;

public class InboxFilter
implements WorkItemFilter {
    private String path;
    private String model;
    private String step;
    private String authorizableType;
    private String assignee;
    private UserManager usrMgr;

    public InboxFilter(UserManager usrMgr, String path, String model, String step, String authorizableType, String assignee) {
        this(usrMgr);
        this.path = path;
        this.model = model;
        this.step = step;
        this.authorizableType = authorizableType;
        this.assignee = assignee;
    }

    public InboxFilter(UserManager usrMgr) {
        this.usrMgr = usrMgr;
    }

    public boolean doInclude(WorkItem item) {
        boolean include = true;
        if (item.getCurrentAssignee() == null) {
            return false;
        }
        if (this.path != null && item.getWorkflowData().getPayloadType().equals("JCR_PATH") && !item.getWorkflowData().getPayload().toString().startsWith(this.path)) {
            include = false;
        }
        if (include && this.model != null && !item.getWorkflow().getWorkflowModel().getId().equals(this.model)) {
            include = false;
        }
        if (include && this.step != null && !item.getNode().getId().equals(this.step)) {
            include = false;
        }
        if (include && this.authorizableType != null) {
            String assignee = item.getCurrentAssignee();
            Authorizable auth = null;
            auth = assignee.startsWith("/") ? this.usrMgr.findByHome(assignee) : this.usrMgr.get(assignee);
            if (auth != null) {
                if (this.authorizableType.equals("user") && !auth.isUser()) {
                    include = false;
                } else if (this.authorizableType.equals("group") && auth.isUser()) {
                    include = false;
                }
            } else {
                include = false;
            }
        }
        if (include && this.assignee != null && !item.getCurrentAssignee().equals(this.assignee)) {
            include = false;
        }
        return include;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public String getStep() {
        return this.step;
    }

    public void setStep(String step) {
        this.step = step;
    }

    public String getAuthorizableType() {
        return this.authorizableType;
    }

    public void setAuthorizableType(String authorizableType) {
        this.authorizableType = authorizableType;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }
}

