/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.workflow.launcher.impl;

import com.adobe.granite.workflow.WorkflowException;
import com.day.cq.workflow.launcher.ConfigEntry;
import com.day.cq.workflow.launcher.WorkflowLauncher;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.adapter.AdapterManager;
import org.apache.sling.jcr.api.SlingRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Component(metatype=false, label="%cq.workflow.launcher.name", description="%cq.workflow.launcher.description")
@Property(name="service.description", value={"%cq.workflow.launcher.description"})
@Service(value={WorkflowLauncher.class})
public class WorkflowLauncherImpl
implements WorkflowLauncher {
    private static final Logger log = LoggerFactory.getLogger(WorkflowLauncherImpl.class);
    @Reference(policy=ReferencePolicy.STATIC)
    private AdapterManager adapterManager;
    @Reference(policy=ReferencePolicy.STATIC)
    private SlingRepository repository;
    private com.adobe.granite.workflow.launcher.WorkflowLauncher graniteLauncherConfig = null;

    public WorkflowLauncherImpl() {
    }

    public WorkflowLauncherImpl(com.adobe.granite.workflow.launcher.WorkflowLauncher graniteLauncherConfig) {
        this.graniteLauncherConfig = graniteLauncherConfig;
    }

    @Override
    public void addConfigEntry(ConfigEntry entry) throws RepositoryException {
        com.adobe.granite.workflow.launcher.ConfigEntry graniteConfigEntry = WorkflowLauncherImpl.translate(entry);
        Session session = null;
        try {
            com.adobe.granite.workflow.launcher.WorkflowLauncher graniteLauncher = this.graniteLauncherConfig;
            if (graniteLauncher == null) {
                session = this.repository.loginAdministrative(null);
                graniteLauncher = (com.adobe.granite.workflow.launcher.WorkflowLauncher)this.adapterManager.getAdapter((Object)session, com.adobe.granite.workflow.launcher.WorkflowLauncher.class);
            }
            graniteLauncher.addConfigEntry(graniteConfigEntry);
            session.save();
        }
        catch (WorkflowException e) {
            throw new RepositoryException("Error adding config entry", (Throwable)e);
        }
        finally {
            if (session != null && session.isLive()) {
                session.logout();
            }
        }
    }

    private static com.adobe.granite.workflow.launcher.ConfigEntry translate(ConfigEntry entry) {
        return new com.adobe.granite.workflow.launcher.ConfigEntry(entry.getEventType(), entry.getGlob(), entry.getNodetype(), entry.getWhereClause(), entry.getWorkflow(), entry.getId(), entry.getDescription(), entry.isEnabled(), entry.getExcludeList(), entry.getRunModes());
    }

    private static ConfigEntry translate(com.adobe.granite.workflow.launcher.ConfigEntry entry) {
        return new ConfigEntry(entry.getEventType(), entry.getGlob(), entry.getNodetype(), entry.getWhereClause(), entry.getWorkflow(), entry.getId(), entry.getDescription(), entry.isEnabled(), entry.getExcludeList(), entry.getRunModes());
    }

    @Override
    public void removeConfigEntry(String id) throws RepositoryException {
        Session session = null;
        try {
            com.adobe.granite.workflow.launcher.WorkflowLauncher graniteLauncher = this.graniteLauncherConfig;
            if (graniteLauncher == null) {
                session = this.repository.loginAdministrative(null);
                graniteLauncher = (com.adobe.granite.workflow.launcher.WorkflowLauncher)this.adapterManager.getAdapter((Object)session, com.adobe.granite.workflow.launcher.WorkflowLauncher.class);
            }
            graniteLauncher.removeConfigEntry(id);
            session.save();
        }
        catch (WorkflowException e) {
            throw new RepositoryException("Error removing config entry", (Throwable)e);
        }
        finally {
            if (session != null && session.isLive()) {
                session.logout();
            }
        }
    }

    @Override
    public List<ConfigEntry> getConfigEntries() {
        Session session = null;
        ArrayList<ConfigEntry> entries = new ArrayList<ConfigEntry>();
        try {
            com.adobe.granite.workflow.launcher.WorkflowLauncher graniteLauncher = this.graniteLauncherConfig;
            if (graniteLauncher == null) {
                session = this.repository.loginAdministrative(null);
                graniteLauncher = (com.adobe.granite.workflow.launcher.WorkflowLauncher)this.adapterManager.getAdapter((Object)session, com.adobe.granite.workflow.launcher.WorkflowLauncher.class);
            }
            Iterator graniteIterator = graniteLauncher.getConfigEntries();
            while (graniteIterator.hasNext()) {
                entries.add(WorkflowLauncherImpl.translate((com.adobe.granite.workflow.launcher.ConfigEntry)graniteIterator.next()));
            }
        }
        catch (WorkflowException e) {
            log.error("Error retrieving config entries", (Throwable)e);
            throw new RuntimeException(e);
        }
        catch (RepositoryException e) {
            log.error("Error retrieving config entries", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (session != null && session.isLive()) {
                session.logout();
            }
        }
        return entries;
    }

    @Override
    public void editConfigEntry(String id, ConfigEntry configEntry) throws RepositoryException {
        Session session = null;
        try {
            com.adobe.granite.workflow.launcher.WorkflowLauncher graniteLauncher = this.graniteLauncherConfig;
            if (graniteLauncher == null) {
                session = this.repository.loginAdministrative(null);
                graniteLauncher = (com.adobe.granite.workflow.launcher.WorkflowLauncher)this.adapterManager.getAdapter((Object)session, com.adobe.granite.workflow.launcher.WorkflowLauncher.class);
            }
            graniteLauncher.editConfigEntry(id, WorkflowLauncherImpl.translate(configEntry));
            session.save();
        }
        catch (WorkflowException e) {
            throw new RepositoryException("Error editing config entry", (Throwable)e);
        }
        finally {
            if (session != null && session.isLive()) {
                session.logout();
            }
        }
    }

    protected void bindAdapterManager(AdapterManager adapterManager) {
        this.adapterManager = adapterManager;
    }

    protected void unbindAdapterManager(AdapterManager adapterManager) {
        if (this.adapterManager == adapterManager) {
            this.adapterManager = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

