/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.workflow.servlet;

import com.day.cq.security.Group;
import com.day.cq.security.User;
import com.day.cq.security.UserManager;
import com.day.cq.security.UserManagerFactory;
import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingAllMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;

@Component(metatype=false)
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.resourceTypes", value={"cq/workflow/components/participants"}), @Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.methods", value={"GET"}), @Property(name="service.description", value={"Workflow Participant List"})})
public class ParticipantListServlet
extends SlingAllMethodsServlet {
    private static final long serialVersionUID = 6712355538430033023L;
    @Reference(policy=ReferencePolicy.STATIC)
    private UserManagerFactory userManagerFactory;

    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        response.setCharacterEncoding("utf-8");
        response.setContentType("application/json");
        Session session = null;
        JSONWriter writer = new JSONWriter((Writer)response.getWriter());
        try {
            session = (Session)request.getResourceResolver().adaptTo(Session.class);
            writer.object();
            writer.key("participants");
            writer.array();
            int count = 0;
            Iterator users = this.getUserManager(session).getUsers();
            while (users.hasNext()) {
                User user = (User)users.next();
                writer.object();
                writer.key("pid").value((Object)user.getID());
                writer.key("label").value((Object)user.getName());
                writer.endObject();
                ++count;
            }
            Iterator groups = this.getUserManager(session).getGroups();
            while (groups.hasNext()) {
                Group group = (Group)groups.next();
                writer.object();
                writer.key("pid").value((Object)group.getID());
                writer.key("label").value((Object)group.getName());
                writer.endObject();
                ++count;
            }
            writer.endArray();
            writer.key("results").value((long)count);
            writer.endObject();
        }
        catch (JSONException e) {
            throw new ServletException((Throwable)e);
        }
        catch (RepositoryException re) {
            throw new ServletException((Throwable)re);
        }
        finally {
            if (session != null) {
                session.logout();
                session = null;
            }
        }
    }

    private UserManager getUserManager(Session session) throws RepositoryException {
        return this.userManagerFactory.createUserManager(session);
    }

    protected void bindUserManagerFactory(UserManagerFactory userManagerFactory) {
        this.userManagerFactory = userManagerFactory;
    }

    protected void unbindUserManagerFactory(UserManagerFactory userManagerFactory) {
        if (this.userManagerFactory == userManagerFactory) {
            this.userManagerFactory = null;
        }
    }
}

