/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.workflow.servlet;

import com.day.cq.workflow.WorkflowException;
import com.day.cq.workflow.WorkflowService;
import com.day.cq.workflow.WorkflowSession;
import com.day.cq.workflow.model.WorkflowModel;
import com.day.cq.workflow.statistics.WorkflowStatisticService;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import java.util.ResourceBundle;
import javax.jcr.RepositoryException;
import javax.servlet.Servlet;
import javax.servlet.ServletException;
import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Properties;
import org.apache.felix.scr.annotations.Property;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferencePolicy;
import org.apache.felix.scr.annotations.Service;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.SlingHttpServletResponse;
import org.apache.sling.api.servlets.SlingSafeMethodsServlet;
import org.apache.sling.commons.json.JSONException;
import org.apache.sling.commons.json.io.JSONWriter;
import org.apache.sling.jcr.api.SlingRepository;

@Component(metatype=false)
@Service(value={Servlet.class})
@Properties(value={@Property(name="sling.servlet.paths", value={"/libs/cq/workflow/statistics"}), @Property(name="sling.servlet.extensions", value={"json"}), @Property(name="sling.servlet.methods", value={"GET"}), @Property(name="service.description", value={"Workflow Statistics Servlet"})})
public class WorkflowStatisticsServlet
extends SlingSafeMethodsServlet {
    @Reference(policy=ReferencePolicy.STATIC)
    private WorkflowStatisticService statService;
    @Reference(policy=ReferencePolicy.STATIC)
    private WorkflowService wfService;
    @Reference(policy=ReferencePolicy.STATIC)
    private SlingRepository repository;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(SlingHttpServletRequest request, SlingHttpServletResponse response) throws ServletException, IOException {
        block18: {
            ResourceBundle resourceBundle = request.getResourceBundle(null);
            response.setCharacterEncoding("utf-8");
            response.setContentType("application/json");
            WorkflowSession wfSession = null;
            try {
                wfSession = this.wfService.getWorkflowSession(this.repository.loginAdministrative(null));
                if (request.getRequestPathInfo().getSelectors().length > 0 && request.getRequestPathInfo().getSelectors()[0].equals("instance")) {
                    String modelId = request.getRequestParameter("model") == null ? null : request.getRequestParameter("model").getString();
                    ArrayList<WorkflowModel> models = new ArrayList<WorkflowModel>();
                    if (modelId != null) {
                        models.add(wfSession.getModel(modelId));
                    } else {
                        models.addAll(Arrays.asList(wfSession.getModels()));
                    }
                    try {
                        JSONWriter writer = new JSONWriter((Writer)response.getWriter());
                        writer.object();
                        writer.key("instances");
                        writer.array();
                        for (WorkflowModel model : models) {
                            writer.object();
                            Map stats = this.statService.getInstanceReport(model);
                            writer.key(model.getId());
                            writer.object();
                            for (Object key : stats.keySet()) {
                                writer.key((String)key).value(stats.get(key));
                            }
                            writer.endObject();
                            writer.endObject();
                        }
                        writer.endArray();
                        writer.key("results").value((long)models.size());
                        writer.endObject();
                        break block18;
                    }
                    catch (JSONException e) {
                        throw new ServletException((Throwable)e);
                    }
                }
                if (request.getRequestPathInfo().getSelectors().length != 0) break block18;
                try {
                    Map wfStat = this.statService.getReport();
                    JSONWriter writer = new JSONWriter((Writer)response.getWriter());
                    writer.object();
                    writer.key("workflow");
                    writer.array();
                    for (Object key : wfStat.keySet()) {
                        writer.object();
                        writer.key((String)key).value(wfStat.get(key));
                        writer.endObject();
                    }
                    writer.endArray();
                    writer.key("results").value((long)wfStat.size());
                    writer.endObject();
                }
                catch (JSONException e) {
                    throw new ServletException((Throwable)e);
                }
            }
            catch (WorkflowException we) {
            }
            catch (RepositoryException re) {
            }
            finally {
                if (wfSession != null) {
                    wfSession.logout();
                }
            }
        }
    }

    protected void bindStatService(WorkflowStatisticService workflowStatisticService) {
        this.statService = workflowStatisticService;
    }

    protected void unbindStatService(WorkflowStatisticService workflowStatisticService) {
        if (this.statService == workflowStatisticService) {
            this.statService = null;
        }
    }

    protected void bindWfService(WorkflowService workflowService) {
        this.wfService = workflowService;
    }

    protected void unbindWfService(WorkflowService workflowService) {
        if (this.wfService == workflowService) {
            this.wfService = null;
        }
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }
}

