/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.personalization.impl;

import com.day.cq.personalization.ProfileProvider;
import com.day.cq.personalization.impl.ContextSessionPersistence;
import com.day.cq.security.profile.Profile;
import com.day.cq.security.profile.ProfileManager;
import com.day.cq.wcm.api.WCMMode;
import java.util.Map;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.servlet.ServletRequest;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.jcr.api.SlingRepository;
import org.apache.sling.settings.SlingSettingsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContextProfileProvider
implements ProfileProvider {
    private final Logger log = LoggerFactory.getLogger(ContextProfileProvider.class);
    private SlingRepository repository = null;
    private ProfileManager profileManager = null;
    private SlingSettingsService settingsService = null;

    public Profile getProfile(SlingHttpServletRequest request) {
        if (WCMMode.DISABLED != WCMMode.fromRequest((ServletRequest)request)) {
            Profile p;
            String authorizableId;
            Map<String, String> contextProfile = ContextSessionPersistence.getStore(request, "PROFILEDATA", this.settingsService);
            if (contextProfile.containsKey("authorizableId")) {
                authorizableId = contextProfile.get("authorizableId");
                try {
                    p = this.profileManager.getProfile(authorizableId, (Session)request.getResourceResolver().adaptTo(Session.class));
                    if (p != null) {
                        return p;
                    }
                }
                catch (RepositoryException e) {
                    this.log.error("error while getting profile: ", (Throwable)e);
                }
            }
            if ((contextProfile = ContextSessionPersistence.getStore(request, "CLICKSTREAMCLOUD", this.settingsService)).containsKey("visitorId")) {
                authorizableId = contextProfile.get("visitorId");
                try {
                    p = this.profileManager.getProfile(authorizableId, (Session)request.getResourceResolver().adaptTo(Session.class));
                    if (p != null) {
                        return p;
                    }
                }
                catch (RepositoryException e) {
                    this.log.error("error while getting profile: ", (Throwable)e);
                }
            }
            try {
                Profile p2 = this.profileManager.getProfile("anonymous", (Session)request.getResourceResolver().adaptTo(Session.class));
                if (p2 != null) {
                    return p2;
                }
            }
            catch (RepositoryException e) {
                this.log.error("error while getting profile: ", (Throwable)e);
            }
        }
        return null;
    }

    public Profile getProfile(ResourceResolver resolver) {
        return null;
    }

    protected void bindRepository(SlingRepository slingRepository) {
        this.repository = slingRepository;
    }

    protected void unbindRepository(SlingRepository slingRepository) {
        if (this.repository == slingRepository) {
            this.repository = null;
        }
    }

    protected void bindProfileManager(ProfileManager profileManager) {
        this.profileManager = profileManager;
    }

    protected void unbindProfileManager(ProfileManager profileManager) {
        if (this.profileManager == profileManager) {
            this.profileManager = null;
        }
    }

    protected void bindSettingsService(SlingSettingsService slingSettingsService) {
        this.settingsService = slingSettingsService;
    }

    protected void unbindSettingsService(SlingSettingsService slingSettingsService) {
        if (this.settingsService == slingSettingsService) {
            this.settingsService = null;
        }
    }
}

