/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.personalization.impl;

import java.net.URLDecoder;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.Cookie;
import org.apache.commons.lang.StringUtils;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.settings.SlingSettingsService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContextSessionPersistence {
    private static final String COOKIE_PREFIX = "SessionPersistence-";

    public static String get(SlingHttpServletRequest request, String key, SlingSettingsService settingsService) {
        int index;
        String pairsMap = ContextSessionPersistence.getMap(request, settingsService);
        String value = "";
        if (pairsMap != null && (index = pairsMap.indexOf(key + ":=")) != -1) {
            int end = pairsMap.indexOf("|", index + 2);
            if (end == -1) {
                end = pairsMap.length();
            }
            value = pairsMap.substring(index + (key + ":=").length(), end);
        }
        value = value == null || "null".equals(value) ? "" : value;
        return value;
    }

    public static String getMap(SlingHttpServletRequest request, SlingSettingsService settingsService) {
        String pairsMap;
        Cookie cookie = request.getCookie(ContextSessionPersistence.getCookieName(settingsService));
        if (cookie != null && (pairsMap = request.getCookie(ContextSessionPersistence.getCookieName(settingsService)).getValue()) != null) {
            return URLDecoder.decode(pairsMap);
        }
        return "";
    }

    private static Map<String, String> parse(String str) {
        HashMap<String, String> obj = new HashMap<String, String>();
        if (str != null) {
            String[] array;
            for (String t : array = str.split(",")) {
                String[] entry = t.split("=");
                if (entry.length != 2) continue;
                obj.put(entry[0], entry[1]);
            }
        }
        return obj;
    }

    public static Map<String, String> getStore(SlingHttpServletRequest request, String key, SlingSettingsService settingsService) {
        return ContextSessionPersistence.parse(ContextSessionPersistence.get(request, key, settingsService));
    }

    public static String getCookieName(SlingSettingsService settingsService) {
        return COOKIE_PREFIX + StringUtils.join((Collection)settingsService.getRunModes(), (String)"-");
    }
}

