/*
 * Decompiled with CFR 0.152.
 */
package com.day.cq.personalization.impl;

import com.day.cq.personalization.ProfileProvider;
import com.day.cq.security.User;
import com.day.cq.security.profile.Profile;
import com.day.cq.security.profile.ProfileManager;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceResolver;
import org.apache.sling.api.resource.ResourceUtil;
import org.apache.sling.api.resource.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProfileProvider
implements ProfileProvider {
    private static final String PARAM_AUTHORIZABLE = "authorizable";
    private static final String PROPERTY_PROFILE = "profile";
    private static final String VARIABLE_ME = "~";
    private final Logger log = LoggerFactory.getLogger(DefaultProfileProvider.class);
    private ProfileManager profileManager;

    public Profile getProfile(SlingHttpServletRequest request) {
        ResourceResolver resourceResolver = request.getResourceResolver();
        Resource resource = request.getResource();
        Profile profile = (Profile)resource.adaptTo(Profile.class);
        if (profile == null) {
            this.log.debug("Resource didn't adapt to an Profile, search for authorizable ID at {}", (Object)resource.getPath());
            ValueMap properties = ResourceUtil.getValueMap((Resource)resource);
            String auth = (String)properties.get(PROPERTY_PROFILE, String.class);
            if (auth == null) {
                this.log.debug("Resource didn't have a authorizable property value at, search request parameter", (Object)resource.getPath());
                auth = request.getParameter(PARAM_AUTHORIZABLE);
            }
            if (auth != null) {
                if (VARIABLE_ME.equals(auth)) {
                    this.log.debug("replaced variable 'me' with current user", (Object)resource.getPath());
                    profile = ((User)resourceResolver.adaptTo(User.class)).getProfile();
                } else {
                    this.log.debug("resolve Profile from request to {} for User {}", (Object)resource.getPath(), (Object)auth);
                    try {
                        return this.profileManager.getProfile(auth, (Session)resourceResolver.adaptTo(Session.class));
                    }
                    catch (RepositoryException e) {
                        this.log.error("error accessing profile: ", (Throwable)e);
                    }
                }
            }
        }
        if (profile == null) {
            profile = this.getProfile(resourceResolver);
        }
        return profile;
    }

    public Profile getProfile(ResourceResolver resolver) {
        User user = (User)resolver.adaptTo(User.class);
        return null != user ? user.getProfile() : null;
    }

    protected void bindProfileManager(ProfileManager profileManager) {
        this.profileManager = profileManager;
    }

    protected void unbindProfileManager(ProfileManager profileManager) {
        if (this.profileManager == profileManager) {
            this.profileManager = null;
        }
    }
}

