/*
 * Decompiled with CFR 0.152.
 */
package com.day.cqse.httpservice.internal;

import com.day.cqse.httpservice.internal.CQSEConfig;
import com.day.cqse.httpservice.internal.CQSEService;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Properties;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedService;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.MetaTypeProvider;
import org.osgi.service.metatype.ObjectClassDefinition;

public class CQSEConfigHandler
implements ManagedService,
MetaTypeProvider {
    private final CQSEService cqse;
    private final ObjectClassDefinition ocd;
    private final Properties metatypeProps;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CQSEConfigHandler(CQSEService cqse) {
        this.cqse = cqse;
        CQSEConfig config = cqse.getDefaultConfig();
        this.metatypeProps = new Properties();
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream("/OSGI-INF/metatype/metatype.properties");
            this.metatypeProps.load(is);
        }
        catch (IOException ignore) {
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ignore) {}
            }
        }
        final ArrayList<AttributeDefinitionImpl> adList = new ArrayList<AttributeDefinitionImpl>();
        adList.add(new AttributeDefinitionImpl(this, "org.apache.felix.http.nio", config.isUseHttpNio()));
        adList.add(new AttributeDefinitionImpl(this, "org.apache.felix.http.timeout", config.getHttpTimeout()));
        adList.add(new AttributeDefinitionImpl(this, "org.apache.felix.https.enable", config.isUseHttps()));
        adList.add(new AttributeDefinitionImpl(this, "org.osgi.service.http.port.secure", config.getHttpsPort()));
        adList.add(new AttributeDefinitionImpl(this, "org.apache.felix.https.nio", config.isUseHttpsNio()));
        adList.add(new AttributeDefinitionImpl(this, "org.apache.felix.https.keystore", config.getKeystore()));
        adList.add(new AttributeDefinitionImpl(this, "org.apache.felix.https.keystore.password", config.getPassword()));
        adList.add(new AttributeDefinitionImpl(this, "org.apache.felix.https.keystore.key", config.getKeyAlias()));
        adList.add(new AttributeDefinitionImpl(this, "org.apache.felix.https.keystore.key.password", config.getKeyPassword()));
        adList.add(new AttributeDefinitionImpl(this, "org.apache.felix.https.clientcertificate", 1, new String[]{config.getClientcert()}, 0, new String[]{this.getMetatypeValue("%clientcertificate.none"), this.getMetatypeValue("%clientcertificate.wants"), this.getMetatypeValue("%clientcertificate.needs")}, new String[]{"none", "wants", "needs"}));
        adList.add(new AttributeDefinitionImpl(this, "org.apache.felix.http.session.timeout", config.getSessionTimeout()));
        adList.add(new AttributeDefinitionImpl(this, "org.apache.felix.http.debug", config.isDebug()));
        this.ocd = new ObjectClassDefinition(){
            private final AttributeDefinition[] attrs;
            {
                this.attrs = adList.toArray(new AttributeDefinition[adList.size()]);
            }

            public String getName() {
                return CQSEConfigHandler.this.getMetatypeValue("%com.day.cqse.httpservice.internal.CQSEConfig.name");
            }

            public InputStream getIcon(int arg0) {
                return null;
            }

            public String getID() {
                return "org.apache.felix.http";
            }

            public String getDescription() {
                return CQSEConfigHandler.this.getMetatypeValue("%com.day.cqse.httpservice.internal.CQSEConfig.description");
            }

            public AttributeDefinition[] getAttributeDefinitions(int filter) {
                return filter == 2 ? null : this.attrs;
            }
        };
    }

    public String getMetatypeValue(String key) {
        String value;
        if (key.startsWith("%")) {
            String propName = key.substring(1);
            value = this.metatypeProps.getProperty(propName, propName);
        } else {
            value = key;
        }
        return value;
    }

    public void updated(Dictionary properties) throws ConfigurationException {
        this.cqse.updated(properties);
    }

    public String[] getLocales() {
        return null;
    }

    public ObjectClassDefinition getObjectClassDefinition(String id, String locale) {
        if (!"org.apache.felix.http".equals(id)) {
            return null;
        }
        return this.ocd;
    }

    class AttributeDefinitionImpl
    implements AttributeDefinition {
        private final String id;
        private final String name;
        private final String description;
        private final int type;
        private final String[] defaultValues;
        private final int cardinality;
        private final String[] optionLabels;
        private final String[] optionValues;
        final /* synthetic */ CQSEConfigHandler this$0;

        AttributeDefinitionImpl(CQSEConfigHandler cQSEConfigHandler, String id, boolean defaultValue) {
            this(cQSEConfigHandler, id, 11, new String[]{String.valueOf(defaultValue)}, 0, null, null);
        }

        AttributeDefinitionImpl(CQSEConfigHandler cQSEConfigHandler, String id, int defaultValue) {
            this(cQSEConfigHandler, id, 3, new String[]{String.valueOf(defaultValue)}, 0, null, null);
        }

        AttributeDefinitionImpl(CQSEConfigHandler cQSEConfigHandler, String id, String defaultValue) {
            String[] stringArray;
            if (defaultValue == null) {
                stringArray = null;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = defaultValue;
            }
            this(cQSEConfigHandler, id, 1, stringArray, 0, null, null);
        }

        AttributeDefinitionImpl(CQSEConfigHandler cQSEConfigHandler, String id, int type, String[] defaultValues, int cardinality, String[] optionLabels, String[] optionValues) {
            this.this$0 = cQSEConfigHandler;
            this.id = id;
            this.name = cQSEConfigHandler.getMetatypeValue("%" + id + ".name");
            this.description = cQSEConfigHandler.getMetatypeValue("%" + id + ".description");
            this.type = type;
            this.defaultValues = defaultValues;
            this.cardinality = cardinality;
            this.optionLabels = optionLabels;
            this.optionValues = optionValues;
        }

        public int getCardinality() {
            return this.cardinality;
        }

        public String[] getDefaultValue() {
            return this.defaultValues;
        }

        public String getDescription() {
            return this.description;
        }

        public String getID() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String[] getOptionLabels() {
            return this.optionLabels;
        }

        public String[] getOptionValues() {
            return this.optionValues;
        }

        public int getType() {
            return this.type;
        }

        public String validate(String arg0) {
            return null;
        }
    }
}

