/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.config;

import com.day.j2ee.config.ConfigException;
import com.day.j2ee.config.DefaultSerializable;
import org.jdom.Element;

public class ConfigProperty
extends DefaultSerializable {
    private static final String ELEMENT_NAME = "config-property-name";
    private static final String ELEMENT_TYPE = "config-property-type";
    private static final String ELEMENT_VALUE = "config-property-value";
    private static final String[] LEGAL_TYPE_NAMES = new String[]{"java.lang.Boolean", "java.lang.String", "java.lang.Integer", "java.lang.Double", "java.lang.Byte", "java.lang.Short", "java.lang.Long", "java.lang.Float", "java.lang.Character"};
    private String name;
    private String type;
    private String value;

    public void read(Element element) throws ConfigException {
        this.name = this.getStringValue(element, ELEMENT_NAME);
        if (this.name == null || this.name.equals("")) {
            throw new ConfigException("The config property name must not be empty.");
        }
        this.type = this.getStringValue(element, ELEMENT_TYPE);
        if (this.type != null && !ConfigProperty.isLegalType(this.type)) {
            throw new ConfigException("The config property type is invalid: " + this.type);
        }
        this.value = this.getStringValue(element, ELEMENT_VALUE);
    }

    public void write(Element element) {
        this.setValue(element, ELEMENT_NAME, this.name);
        this.setValue(element, ELEMENT_TYPE, this.type);
        this.setValue(element, ELEMENT_VALUE, this.value);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("The config property name must not be empty.");
        }
        this.name = name;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (type != null && !ConfigProperty.isLegalType(type)) {
            throw new IllegalArgumentException("The config property type is invalid: " + type);
        }
        this.type = type;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    private static boolean isLegalType(String type) {
        for (int i = 0; i < LEGAL_TYPE_NAMES.length; ++i) {
            if (!LEGAL_TYPE_NAMES[i].equals(type)) continue;
            return true;
        }
        return false;
    }
}

