/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.config;

import com.day.j2ee.config.ConfigException;
import com.day.j2ee.config.ConfigProperty;
import com.day.j2ee.config.DefaultSerializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Element;

public final class Connector
extends DefaultSerializable {
    private static final String ELEMENT_JNDI_NAME = "jndi-name";
    private static final String ELEMENT_PATH = "path";
    private static final String ELEMENT_CONFIG_PROPERTY = "config-property";
    private static final String ELEMENT_LEVEL = "log-level";
    private String jndiName;
    private String path;
    private transient Map propertyMap;
    private List properties = new ArrayList();
    private String level;

    public void read(Element element) throws ConfigException {
        this.jndiName = this.getStringValue(element, ELEMENT_JNDI_NAME);
        if (!Connector.isValidJndiName(this.jndiName)) {
            throw new ConfigException("The JNDI name is invalid: " + this.jndiName);
        }
        this.path = this.getStringValue(element, ELEMENT_PATH);
        Iterator iter = element.getChildren(ELEMENT_CONFIG_PROPERTY).iterator();
        while (iter.hasNext()) {
            ConfigProperty property = new ConfigProperty();
            property.read((Element)iter.next());
            this.properties.add(property);
        }
        this.level = this.getStringValue(element, ELEMENT_LEVEL);
    }

    public void write(Element element) {
        this.setValue(element, ELEMENT_JNDI_NAME, this.jndiName);
        this.setValue(element, ELEMENT_PATH, this.path);
        Iterator iter = this.properties.iterator();
        while (iter.hasNext()) {
            ConfigProperty property = (ConfigProperty)iter.next();
            this.setValue(element, ELEMENT_CONFIG_PROPERTY, property);
        }
        this.setValue(element, ELEMENT_LEVEL, this.level);
    }

    public void setJndiName(String jndiName) {
        if (!Connector.isValidJndiName(jndiName)) {
            throw new IllegalArgumentException("The JNDI name is invalid: " + jndiName);
        }
        this.jndiName = jndiName;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public List getConfigProperties() {
        return this.properties;
    }

    public ConfigProperty getProperty(String name) {
        if (this.propertyMap == null) {
            this.propertyMap = new HashMap();
            Iterator iter = this.properties.iterator();
            while (iter.hasNext()) {
                ConfigProperty property = (ConfigProperty)iter.next();
                this.propertyMap.put(property.getName(), property);
            }
        }
        return (ConfigProperty)this.propertyMap.get(name);
    }

    public void setConfigProperties(List properties) {
        this.properties = properties;
    }

    public void setLevel(String level) {
        this.level = level;
    }

    public String getLevel() {
        return this.level;
    }

    private static boolean isValidJndiName(String jndiName) {
        return jndiName != null && !jndiName.equals("") && jndiName.indexOf(47) != 0;
    }
}

