/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.config;

import com.day.j2ee.config.ConfigException;
import com.day.j2ee.config.Connector;
import com.day.j2ee.config.DefaultSerializable;
import com.day.j2ee.config.Listener;
import com.day.j2ee.config.LogFile;
import com.day.j2ee.config.WebApplication;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;

public final class Container
extends DefaultSerializable {
    private static final String ELEMENT_LISTENER = "listener";
    private static final String ELEMENT_WEB_APP = "web-app";
    private static final String ELEMENT_CONNECTOR = "connector";
    private static final String ELEMENT_LOG_FILE = "log-file";
    private List listeners = new ArrayList();
    private List webapps = new ArrayList();
    private List connectors = new ArrayList();
    private LogFile logFile;

    public void read(Element element) throws ConfigException {
        Iterator iter = element.getChildren(ELEMENT_LISTENER).iterator();
        while (iter.hasNext()) {
            Listener listener = new Listener();
            listener.read((Element)iter.next());
            this.listeners.add(listener);
        }
        iter = element.getChildren(ELEMENT_WEB_APP).iterator();
        while (iter.hasNext()) {
            WebApplication webapp = new WebApplication();
            webapp.read((Element)iter.next());
            this.webapps.add(webapp);
        }
        iter = element.getChildren(ELEMENT_CONNECTOR).iterator();
        while (iter.hasNext()) {
            Connector connector = new Connector();
            connector.read((Element)iter.next());
            this.connectors.add(connector);
        }
        Element child = element.getChild(ELEMENT_LOG_FILE);
        if (child != null) {
            this.logFile = new LogFile();
            this.logFile.read(child);
        }
    }

    public void write(Element element) {
        Iterator iter = this.listeners.iterator();
        while (iter.hasNext()) {
            Listener listener = (Listener)iter.next();
            this.setValue(element, ELEMENT_LISTENER, listener);
        }
        iter = this.webapps.iterator();
        while (iter.hasNext()) {
            WebApplication webapp = (WebApplication)iter.next();
            this.setValue(element, ELEMENT_WEB_APP, webapp);
        }
        iter = this.connectors.iterator();
        while (iter.hasNext()) {
            Connector connector = (Connector)iter.next();
            this.setValue(element, ELEMENT_CONNECTOR, connector);
        }
        this.setValue(element, ELEMENT_LOG_FILE, this.logFile);
    }

    public List getListeners() {
        return this.listeners;
    }

    public void setListeners(List listeners) {
        this.listeners = listeners;
    }

    public List getWebapps() {
        return this.webapps;
    }

    public void setWebapps(List webapps) {
        this.webapps = webapps;
    }

    public void addWebapp(WebApplication webapp) {
        this.webapps.add(webapp);
    }

    public void removeWebapp(WebApplication webapp) {
        this.webapps.remove(webapp);
    }

    public List getConnectors() {
        return this.connectors;
    }

    public void setConnectors(List connectors) {
        this.connectors = connectors;
    }

    public void addConnector(Connector connector) {
        this.connectors.add(connector);
    }

    public boolean removeConnector(Connector connector) {
        return this.connectors.remove(connector);
    }

    public LogFile getLogFile() {
        return this.logFile;
    }

    public void setLogFile(LogFile logFile) {
        this.logFile = logFile;
    }
}

