/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.config;

import com.day.j2ee.config.ConfigException;
import com.day.j2ee.config.Serializable;
import org.jdom.Element;

abstract class DefaultSerializable
implements Serializable,
Cloneable {
    DefaultSerializable() {
    }

    protected void setValue(Element parent, String name, Object value) {
        if (value != null) {
            Element child = new Element(name, parent.getNamespace());
            child.setText(String.valueOf(value));
            parent.addContent(child);
        }
    }

    protected void setValue(Element parent, String name, Serializable value) {
        if (value != null) {
            Element child = new Element(name, parent.getNamespace());
            value.write(child);
            parent.addContent(child);
        }
    }

    protected Integer getIntegerValue(Element element, String name) throws ConfigException {
        String value = element.getChildTextTrim(name, element.getNamespace());
        if (value != null) {
            try {
                return Integer.valueOf(value);
            }
            catch (RuntimeException e) {
                throw new ConfigException("Bad '" + name + "' value: " + value);
            }
        }
        return null;
    }

    protected Boolean getBooleanValue(Element element, String name) {
        return this.getBooleanValue(element, name, null);
    }

    protected Boolean getBooleanValue(Element element, String name, Boolean defaultValue) {
        String value = element.getChildTextTrim(name, element.getNamespace());
        if (value != null) {
            return Boolean.valueOf(value);
        }
        return defaultValue;
    }

    protected String getStringValue(Element element, String name) {
        return element.getChildTextTrim(name, element.getNamespace());
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError("clone not supported");
        }
    }
}

