/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.config;

import java.util.HashMap;
import java.util.Map;

public class Dispatcher {
    public static final Dispatcher FORWARD = new Dispatcher("FORWARD", 1);
    public static final Dispatcher INCLUDE = new Dispatcher("INCLUDE", 2);
    public static final Dispatcher REQUEST = new Dispatcher("REQUEST", 4);
    public static final Dispatcher ERROR = new Dispatcher("ERROR", 8);
    public static final Dispatcher ALL = new Dispatcher("*", -1);
    private static final Map VALUES = new HashMap();
    private final String name;
    final int value;

    private Dispatcher(String name, int value) {
        this.name = name;
        this.value = value;
    }

    public static Dispatcher valueOf(String s) throws IllegalArgumentException {
        Dispatcher value = (Dispatcher)VALUES.get(s);
        if (value == null) {
            String msg = "Unknown dispatcher value: " + s;
            throw new IllegalArgumentException(msg);
        }
        return value;
    }

    static {
        VALUES.put(Dispatcher.FORWARD.name, FORWARD);
        VALUES.put(Dispatcher.INCLUDE.name, INCLUDE);
        VALUES.put(Dispatcher.REQUEST.name, REQUEST);
        VALUES.put(Dispatcher.ERROR.name, ERROR);
        VALUES.put(Dispatcher.ALL.name, ALL);
    }

    public static class Set {
        private int value;

        public void add(Dispatcher dispatcher) {
            this.value |= dispatcher.value;
        }

        public boolean contains(Dispatcher dispatcher) {
            return (this.value & dispatcher.value) != 0;
        }
    }
}

