/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.config;

import com.day.j2ee.config.ConfigException;
import com.day.j2ee.config.ConfigProperty;
import com.day.j2ee.config.DefaultSerializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Element;

public final class ResourceAdapter
extends DefaultSerializable {
    private static final String ELEMENT_MCF_CLASS = "managedconnectionfactory-class";
    private static final String ELEMENT_CFI_CLASS = "connectionfactory-impl-class";
    private static final String ELEMENT_CONFIG_PROPERTY = "config-property";
    private String mcfClass;
    private String cfiClass;
    private List properties = new ArrayList();
    private transient Map propertyMap;

    public void read(Element element) throws ConfigException {
        this.mcfClass = this.getStringValue(element, ELEMENT_MCF_CLASS);
        this.cfiClass = this.getStringValue(element, ELEMENT_CFI_CLASS);
        Iterator iter = element.getChildren(ELEMENT_CONFIG_PROPERTY).iterator();
        while (iter.hasNext()) {
            ConfigProperty property = new ConfigProperty();
            property.read((Element)iter.next());
            this.properties.add(property);
        }
    }

    public void write(Element element) {
        this.setValue(element, ELEMENT_MCF_CLASS, this.mcfClass);
        this.setValue(element, ELEMENT_CFI_CLASS, this.cfiClass);
        Iterator iter = this.properties.iterator();
        while (iter.hasNext()) {
            ConfigProperty property = (ConfigProperty)iter.next();
            this.setValue(element, ELEMENT_CONFIG_PROPERTY, property);
        }
    }

    public void setMcfClass(String mcfClass) {
        this.mcfClass = mcfClass;
    }

    public String getMcfClass() {
        return this.mcfClass;
    }

    public void setCfiClass(String cfiClass) {
        this.cfiClass = cfiClass;
    }

    public String getCfiClass() {
        return this.cfiClass;
    }

    public List getConfigProperties() {
        return this.properties;
    }

    public ConfigProperty getProperty(String name) {
        if (this.propertyMap == null) {
            this.propertyMap = new HashMap();
            Iterator iter = this.properties.iterator();
            while (iter.hasNext()) {
                ConfigProperty property = (ConfigProperty)iter.next();
                this.propertyMap.put(property.getName(), property);
            }
        }
        return (ConfigProperty)this.propertyMap.get(name);
    }

    public void setConfigProperties(List properties) {
        this.properties = properties;
    }
}

