/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.config;

import com.day.j2ee.config.ConfigException;
import com.day.j2ee.config.DefaultSerializable;
import com.day.j2ee.config.LogFile;
import com.day.j2ee.config.ServletEngine;
import org.jdom.Element;

public class ServerXml
extends DefaultSerializable {
    public static final String PUBLIC_ID = "-//Day Software AG//DTD J2EE Server 3.0//EN";
    public static final String SYSTEM_ID = "http://www.day.com/dtds/server_3_0.dtd";
    public static final String ROOT_ELEMENT = "server";
    private static final String ATTRIBUTE_PORT = "port";
    private static final String ATTRIBUTE_COMMAND = "command";
    private static final String ELEMENT_SERVLETENGINE = "servletengine";
    private static final String ELEMENT_LOG_FILE = "log-file";
    private static final String ELEMENT_LOG_LEVEL = "log-level";
    private static final int DEFAULT_PORT = 8005;
    private static final String DEFAULT_COMMAND = "quit";
    private int shutdownPort;
    private String shutdownCommand;
    private ServletEngine servletEngine;
    private LogFile logFile;
    private String logLevel;

    public void read(Element element) throws ConfigException {
        Element child;
        String portString = element.getAttributeValue(ATTRIBUTE_PORT);
        if (portString != null) {
            try {
                this.shutdownPort = Integer.parseInt(portString);
                if (this.shutdownPort < 0 || this.shutdownPort >= 65536) {
                    this.shutdownPort = 8005;
                }
            }
            catch (NumberFormatException nfe) {
                this.shutdownPort = 8005;
            }
        } else {
            this.shutdownPort = 8005;
        }
        this.shutdownCommand = element.getAttributeValue(ATTRIBUTE_COMMAND);
        if (this.shutdownCommand == null) {
            this.shutdownCommand = DEFAULT_COMMAND;
        }
        if ((child = element.getChild(ELEMENT_SERVLETENGINE)) != null) {
            this.servletEngine = new ServletEngine();
            this.servletEngine.read(child);
        }
        if ((child = element.getChild(ELEMENT_LOG_FILE)) != null) {
            this.logFile = new LogFile();
            this.logFile.read(child);
        }
        this.logLevel = this.getStringValue(element, ELEMENT_LOG_LEVEL);
    }

    public void write(Element element) {
        if (this.shutdownPort != 8005) {
            element.setAttribute(ATTRIBUTE_PORT, String.valueOf(this.shutdownPort));
        }
        if (!this.shutdownCommand.equals(DEFAULT_COMMAND)) {
            element.setAttribute(ATTRIBUTE_COMMAND, this.shutdownCommand);
        }
        this.setValue(element, ELEMENT_SERVLETENGINE, this.servletEngine);
        this.setValue(element, ELEMENT_LOG_FILE, this.logFile);
        this.setValue(element, ELEMENT_LOG_LEVEL, this.logLevel);
    }

    public int getShutdownPort() {
        return this.shutdownPort;
    }

    public void setShutdownPort(int shutdownPort) {
        if (shutdownPort < 0 || shutdownPort >= 65536) {
            this.shutdownPort = shutdownPort;
        }
    }

    public String getShutdownCommand() {
        return this.shutdownCommand;
    }

    public void setShutdownCommand(String shutdownCommand) {
        if (shutdownCommand != null && shutdownCommand.length() > 0) {
            this.shutdownCommand = shutdownCommand;
        }
    }

    public ServletEngine getServletEngine() {
        return this.servletEngine;
    }

    public void setServletEngine(ServletEngine servletEngine) {
        this.servletEngine = servletEngine;
    }

    public LogFile getLogFile() {
        return this.logFile;
    }

    public void setLogFile(LogFile logFile) {
        this.logFile = logFile;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }
}

