/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.config;

import com.day.j2ee.config.ConfigException;
import com.day.j2ee.config.DefaultSerializable;
import com.day.j2ee.config.Param;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jdom.Element;
import org.jdom.Namespace;

public class Servlet
extends DefaultSerializable {
    private static final String ELEMENT_SERVLET_NAME = "servlet-name";
    private static final String ELEMENT_SERVLET_CLASS = "servlet-class";
    private static final String ELEMENT_JSP_FILE = "jsp-file";
    private static final String ELEMENT_INIT_PARAM = "init-param";
    private static final String ELEMENT_LOAD_ON_STARTUP = "load-on-startup";
    private String servletName;
    private String servletClass;
    private String jspFile;
    private List initParams = new ArrayList();
    private String loadOnStartup;
    private transient Map initParamMap;
    private transient Integer loadOnStartupInt;

    public void read(Element element) throws ConfigException {
        Namespace ns = element.getNamespace();
        this.servletName = this.getStringValue(element, ELEMENT_SERVLET_NAME);
        this.servletClass = this.getStringValue(element, ELEMENT_SERVLET_CLASS);
        this.jspFile = this.getStringValue(element, ELEMENT_JSP_FILE);
        this.loadOnStartup = this.getStringValue(element, ELEMENT_LOAD_ON_STARTUP);
        if (this.loadOnStartup != null && !this.loadOnStartup.equals("")) {
            try {
                this.loadOnStartupInt = Integer.valueOf(this.loadOnStartup);
            }
            catch (RuntimeException e) {
                throw new ConfigException("Bad 'load-on-startup' value: " + this.loadOnStartup);
            }
        }
        Iterator iter = element.getChildren(ELEMENT_INIT_PARAM, ns).iterator();
        while (iter.hasNext()) {
            Param param = new Param();
            param.read((Element)iter.next());
            this.initParams.add(param);
        }
    }

    public void write(Element element) {
        this.setValue(element, ELEMENT_SERVLET_NAME, this.servletName);
        this.setValue(element, ELEMENT_SERVLET_CLASS, this.servletClass);
        this.setValue(element, ELEMENT_JSP_FILE, this.jspFile);
        this.setValue(element, ELEMENT_LOAD_ON_STARTUP, this.loadOnStartup);
        Iterator iter = this.initParams.iterator();
        while (iter.hasNext()) {
            Param param = (Param)iter.next();
            this.setValue(element, ELEMENT_INIT_PARAM, param);
        }
    }

    public String getServletName() {
        return this.servletName;
    }

    public void setServletName(String servletName) {
        this.servletName = servletName;
    }

    public String getServletClass() {
        return this.servletClass;
    }

    public void setServletClass(String servletClass) {
        this.servletClass = servletClass;
        this.jspFile = null;
    }

    public String getJspFile() {
        return this.jspFile;
    }

    public void setJspFile(String jspFile) {
        this.jspFile = jspFile;
        this.servletClass = null;
    }

    public List getInitParams() {
        return this.initParams;
    }

    public void setInitParams(List initParams) {
        this.initParams = initParams;
    }

    public void addInitParam(Param initParam) {
        this.initParams.add(initParam);
    }

    public String getLoadOnStartup() {
        return this.loadOnStartup;
    }

    public Integer getLoadOnStartupInt() {
        return this.loadOnStartupInt;
    }

    public void setLoadOnStartup(String loadOnStartup) {
        if (loadOnStartup != null && !loadOnStartup.equals("")) {
            try {
                this.loadOnStartupInt = Integer.valueOf(loadOnStartup);
            }
            catch (RuntimeException e) {
                throw new IllegalArgumentException("Bad integer value: " + loadOnStartup);
            }
        }
        this.loadOnStartup = loadOnStartup;
    }

    public Iterator initParamNames() {
        if (this.initParamMap == null) {
            this.setupInitParamMap();
        }
        return this.initParamMap.keySet().iterator();
    }

    public Param getInitParam(String paramName) {
        if (this.initParamMap == null) {
            this.setupInitParamMap();
        }
        return (Param)this.initParamMap.get(paramName);
    }

    protected void setupInitParamMap() {
        this.initParamMap = new HashMap();
        Iterator iter = this.initParams.iterator();
        while (iter.hasNext()) {
            Param param = (Param)iter.next();
            this.initParamMap.put(param.getParamName(), param);
        }
    }
}

