/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.config;

import com.day.j2ee.config.ConfigException;
import com.day.j2ee.config.CookieConfig;
import com.day.j2ee.config.DefaultSerializable;
import org.jdom.Element;

public class SessionConfig
extends DefaultSerializable {
    private static final String ELEMENT_SESSION_TIMEOUT = "session-timeout";
    private static final String ELEMENT_COOKIE_CONFIG = "cookie-config";
    private Integer sessionTimeout;
    private CookieConfig cookieConfig;

    public void read(Element element) throws ConfigException {
        this.sessionTimeout = this.getIntegerValue(element, ELEMENT_SESSION_TIMEOUT);
        Element child = element.getChild(ELEMENT_COOKIE_CONFIG, element.getNamespace());
        if (child != null) {
            this.cookieConfig = new CookieConfig();
            this.cookieConfig.read(child);
        }
    }

    public void write(Element element) {
        this.setValue(element, ELEMENT_SESSION_TIMEOUT, this.sessionTimeout);
        this.setValue(element, ELEMENT_COOKIE_CONFIG, this.cookieConfig);
    }

    public CookieConfig getCookieConfig() {
        return this.cookieConfig;
    }

    public Integer getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(Integer sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }
}

