/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.config;

import com.day.j2ee.config.DefaultSerializable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jdom.Element;
import org.jdom.Namespace;

public class WebResourceCollection
extends DefaultSerializable {
    private static final String ELEMENT_WEB_RESOURCE_NAME = "web-resource-name";
    private static final String ELEMENT_DESCRIPTION = "description";
    private static final String ELEMENT_URL_PATTERN = "url-pattern";
    private static final String ELEMENT_HTTP_METHOD = "http-method";
    private String webResourceName;
    private String description;
    private List urlPatterns = new ArrayList();
    private List httpMethods = new ArrayList();

    public void read(Element element) {
        Namespace ns = element.getNamespace();
        this.webResourceName = this.getStringValue(element, ELEMENT_WEB_RESOURCE_NAME);
        this.description = this.getStringValue(element, ELEMENT_DESCRIPTION);
        Iterator iter = element.getChildren(ELEMENT_URL_PATTERN, ns).iterator();
        while (iter.hasNext()) {
            Element urlPattern = (Element)iter.next();
            this.urlPatterns.add(urlPattern.getTextTrim());
        }
        iter = element.getChildren(ELEMENT_HTTP_METHOD, ns).iterator();
        while (iter.hasNext()) {
            Element httpMethod = (Element)iter.next();
            this.httpMethods.add(httpMethod.getTextTrim());
        }
    }

    public void write(Element element) {
        this.setValue(element, ELEMENT_WEB_RESOURCE_NAME, this.webResourceName);
        this.setValue(element, ELEMENT_DESCRIPTION, this.description);
        Iterator iter = this.urlPatterns.iterator();
        while (iter.hasNext()) {
            String urlPattern = (String)iter.next();
            this.setValue(element, ELEMENT_URL_PATTERN, urlPattern);
        }
        iter = this.httpMethods.iterator();
        while (iter.hasNext()) {
            String httpMethod = (String)iter.next();
            this.setValue(element, ELEMENT_HTTP_METHOD, httpMethod);
        }
    }

    public String getWebResourceName() {
        return this.webResourceName;
    }

    public void setWebResourceName(String webResourceName) {
        this.webResourceName = webResourceName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean hasURLPatterns() {
        return this.urlPatterns.size() > 0;
    }

    public List getURLPatterns() {
        return this.urlPatterns;
    }

    public void setURLPatterns(List urlPatterns) {
        this.urlPatterns = urlPatterns;
    }

    public boolean hasHttpMethods() {
        return this.httpMethods.size() > 0;
    }

    public List getHttpMethods() {
        return this.httpMethods;
    }

    public void setHttpMethods(List httpMethods) {
        this.httpMethods = httpMethods;
    }
}

