/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.config;

import com.day.j2ee.config.ConfigException;
import com.day.j2ee.config.WebXml;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class WebXmlReader
implements EntityResolver {
    private static final Logger SEL = LoggerFactory.getLogger((String)"servletengine");
    private static final String RESOURCE_NAME_2_2 = "/resources/dtd/web-app_2_2.dtd";
    private static final String RESOURCE_NAME_2_3 = "/resources/dtd/web-app_2_3.dtd";
    private static final String WEB_APP_PREFIX = "web-app_";
    private static final String RESOURCE_DIR = "/resources";
    private static final Map resourceMap = new HashMap();
    private final WebXml webXml = new WebXml();
    private WebXml.Version version;

    private Document createDocument(File file) throws JDOMException, IOException {
        SAXBuilder builder = new SAXBuilder();
        builder.setEntityResolver(this);
        builder.setValidation(true);
        builder.setFeature("http://apache.org/xml/features/validation/schema", true);
        return builder.build(file);
    }

    public static WebXml parse(File xmlFile) throws IOException, ConfigException {
        WebXmlReader xmlReader = new WebXmlReader();
        xmlReader.read(xmlFile);
        return xmlReader.getWebXml();
    }

    public void read(File xmlFile) throws IOException, ConfigException {
        if (!xmlFile.exists()) {
            throw new IOException("web application descriptor not found: " + xmlFile.getPath());
        }
        if (!xmlFile.canRead()) {
            throw new IOException("unable to read web application descriptor: " + xmlFile.getPath());
        }
        try {
            Document doc = this.createDocument(xmlFile);
            if (this.version != null) {
                this.webXml.setVersion(this.version);
            }
            this.webXml.read(doc.getRootElement());
        }
        catch (JDOMException e) {
            ConfigException ce = new ConfigException(e.getMessage(), e);
            throw ce;
        }
    }

    public WebXml getWebXml() {
        return this.webXml;
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        String ext;
        String file;
        int sep;
        String resourceLocation = null;
        if (publicId != null) {
            resourceLocation = (String)resourceMap.get(publicId);
        }
        if (resourceLocation == null && systemId != null && (sep = systemId.lastIndexOf(47)) != -1 && (sep = (file = systemId.substring(sep + 1)).indexOf(46)) != -1 && (ext = file.substring(sep + 1)).indexOf(46) == -1) {
            resourceLocation = "/resources/" + ext + "/" + file;
        }
        if (resourceLocation != null) {
            InputStream in = this.getClass().getResourceAsStream(resourceLocation);
            if (in == null) {
                SEL.warn("Unable to locate internal resource: {}", (Object)resourceLocation);
            } else {
                String v;
                String resourceName;
                int sep2 = resourceLocation.lastIndexOf(47);
                if (sep2 != -1 && (resourceName = resourceLocation.substring(sep2 + 1)).startsWith(WEB_APP_PREFIX) && (v = resourceName.substring(WEB_APP_PREFIX.length())).length() >= 3) {
                    this.version = WebXml.Version.valueOf(v.substring(0, 3).replace('_', '.'));
                }
                InputSource is = new InputSource(in);
                if (systemId != null) {
                    is.setSystemId(systemId);
                }
                return is;
            }
        }
        SEL.warn("Entity unresolved: publicId=\"{}\", systemId=\"{}\"", (Object)publicId, (Object)systemId);
        return null;
    }

    static {
        resourceMap.put("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", RESOURCE_NAME_2_2);
        resourceMap.put("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", RESOURCE_NAME_2_3);
    }
}

