/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.jndi;

import java.util.Hashtable;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;

public class JavaContext
implements Context {
    private static final String JAVA_PREFIX = "java:";
    private Context delegatee;

    public JavaContext(Context delegatee) {
        this.delegatee = delegatee;
    }

    public void close() throws NamingException {
        this.delegatee.close();
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        return this.delegatee.composeName(name, prefix);
    }

    public String composeName(String name, String prefix) throws NamingException {
        return this.delegatee.composeName(name, prefix);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.delegatee.getEnvironment();
    }

    public String getNameInNamespace() throws NamingException {
        return this.delegatee.getNameInNamespace();
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return this.delegatee.getNameParser(JavaContext.removeNamespace(name));
    }

    public NameParser getNameParser(String name) throws NamingException {
        return this.delegatee.getNameParser(JavaContext.removeNamespace(name));
    }

    public NamingEnumeration list(Name name) throws NamingException {
        return this.delegatee.list(JavaContext.removeNamespace(name));
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.delegatee.list(JavaContext.removeNamespace(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        return this.delegatee.listBindings(JavaContext.removeNamespace(name));
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.delegatee.listBindings(JavaContext.removeNamespace(name));
    }

    public Object lookup(Name name) throws NamingException {
        Object o = this.delegatee.lookup(JavaContext.removeNamespace(name));
        if (o instanceof Context) {
            return new JavaContext((Context)o);
        }
        return o;
    }

    public Object lookup(String name) throws NamingException {
        Object o = this.delegatee.lookup(JavaContext.removeNamespace(name));
        if (o instanceof Context) {
            return new JavaContext((Context)o);
        }
        return o;
    }

    public Object lookupLink(Name name) throws NamingException {
        Object o = this.delegatee.lookupLink(JavaContext.removeNamespace(name));
        if (o instanceof Context) {
            return new JavaContext((Context)o);
        }
        return o;
    }

    public Object lookupLink(String name) throws NamingException {
        Object o = this.delegatee.lookupLink(JavaContext.removeNamespace(name));
        if (o instanceof Context) {
            return new JavaContext((Context)o);
        }
        return o;
    }

    public void bind(Name name, Object obj) throws NamingException {
        throw new OperationNotSupportedException("bind");
    }

    public void bind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException("bind");
    }

    public Context createSubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("createSubcontext");
    }

    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("createSubcontext");
    }

    public void destroySubcontext(Name name) throws NamingException {
        throw new OperationNotSupportedException("destroySubcontext");
    }

    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException("destroySubcontext");
    }

    public void rebind(Name name, Object obj) throws NamingException {
        throw new OperationNotSupportedException("rebind");
    }

    public void rebind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException("rebind");
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        throw new OperationNotSupportedException("rename");
    }

    public void rename(String oldName, String newName) throws NamingException {
        throw new OperationNotSupportedException("rename");
    }

    public void unbind(Name name) throws NamingException {
        throw new OperationNotSupportedException("unbind");
    }

    public void unbind(String name) throws NamingException {
        throw new OperationNotSupportedException("unbind");
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        throw new OperationNotSupportedException("addToEnvironment");
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        throw new OperationNotSupportedException("removeFromEnvironment");
    }

    private static Name removeNamespace(Name name) throws NamingException {
        String first;
        if (name.size() > 0 && (first = name.get(0)).startsWith(JAVA_PREFIX)) {
            name.remove(0);
            name = name.add(0, first.substring(JAVA_PREFIX.length()));
        }
        return name;
    }

    private static String removeNamespace(String name) {
        if (name.startsWith(JAVA_PREFIX)) {
            name = name.substring(JAVA_PREFIX.length());
        }
        return name;
    }
}

