/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.jndi;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Binding;
import javax.naming.CompositeName;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.LinkRef;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;

public class SimpleContext
extends Hashtable
implements Context {
    private transient Hashtable environment;
    private static final NameParser nameParser = new SimpleNameParser();

    public SimpleContext() {
        this((Hashtable)null);
    }

    public SimpleContext(Hashtable environment) {
        this.environment = environment == null ? new Hashtable() : (Hashtable)environment.clone();
    }

    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name, obj, false);
    }

    public void bind(Name name, Object obj, boolean intermediate) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("empty name");
        }
        String child = name.get(0);
        if (name.size() == 1) {
            if (this.containsKey(child)) {
                throw new NameAlreadyBoundException(child);
            }
            this.put(child, obj);
            return;
        }
        Object o = this.get(child);
        if (o == null && intermediate) {
            o = new SimpleContext();
            this.put(child, o);
        }
        if (o instanceof SimpleContext) {
            ((SimpleContext)o).bind(name.getSuffix(1), obj, intermediate);
            return;
        }
        throw new NameNotFoundException(child);
    }

    public void bind(String name, Object obj) throws NamingException {
        this.bind(nameParser.parse(name), obj);
    }

    public void bind(String name, Object obj, boolean intermediate) throws NamingException {
        this.bind(nameParser.parse(name), obj, intermediate);
    }

    public void close() throws NamingException {
    }

    public Name composeName(Name name, Name prefix) throws NamingException {
        Name newName = (Name)prefix.clone();
        return newName.addAll(name);
    }

    public String composeName(String name, String prefix) throws NamingException {
        return this.composeName(new CompositeName(name), new CompositeName(prefix)).toString();
    }

    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name, false);
    }

    public Context createSubcontext(Name name, boolean intermediate) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("empty name");
        }
        String child = name.get(0);
        if (name.size() == 1) {
            if (this.containsKey(child)) {
                throw new NameAlreadyBoundException(child);
            }
            SimpleContext ctx = new SimpleContext();
            this.put(child, ctx);
            return ctx;
        }
        Object o = this.get(child);
        if (o == null && intermediate) {
            o = new SimpleContext();
            this.put(child, o);
        }
        if (o instanceof SimpleContext) {
            return ((SimpleContext)o).createSubcontext(name.getSuffix(1), intermediate);
        }
        throw new NameNotFoundException(child);
    }

    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(nameParser.parse(name));
    }

    public Context createSubcontext(String name, boolean intermediate) throws NamingException {
        return this.createSubcontext(nameParser.parse(name), intermediate);
    }

    public void destroySubcontext(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("empty name");
        }
        String child = name.get(0);
        if (name.size() == 1) {
            this.remove(child);
            return;
        }
        Object o = this.get(child);
        if (o instanceof Context) {
            ((Context)o).destroySubcontext(name.getSuffix(1));
            return;
        }
        throw new NameNotFoundException(child);
    }

    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(nameParser.parse(name));
    }

    public Hashtable getEnvironment() throws NamingException {
        return (Hashtable)this.environment.clone();
    }

    public String getNameInNamespace() throws NamingException {
        throw new OperationNotSupportedException("getNameInNamespace");
    }

    public NameParser getNameParser(Name name) throws NamingException {
        return nameParser;
    }

    public NameParser getNameParser(String name) throws NamingException {
        return nameParser;
    }

    public NamingEnumeration list(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new NamingEnum(this);
        }
        Object o = this.lookup(name);
        if (o instanceof Context) {
            return ((Context)o).list(name.getSuffix(name.size() - 1));
        }
        throw new NameNotFoundException(name.toString());
    }

    public NamingEnumeration list(String name) throws NamingException {
        return this.list(nameParser.parse(name));
    }

    public NamingEnumeration listBindings(Name name) throws NamingException {
        if (name.isEmpty()) {
            return new BindingEnum(this);
        }
        Object o = this.lookup(name);
        if (o instanceof Context) {
            return ((Context)o).listBindings(name.getSuffix(name.size() - 1));
        }
        throw new NameNotFoundException(name.toString());
    }

    public NamingEnumeration listBindings(String name) throws NamingException {
        return this.listBindings(nameParser.parse(name));
    }

    public Object lookup(Name name) throws NamingException {
        Object o = this.lookupLink(name);
        if (o instanceof LinkRef) {
            return this.resolveObject((LinkRef)o);
        }
        return o;
    }

    public Object lookup(String name) throws NamingException {
        return this.lookup(nameParser.parse(name));
    }

    public Object lookupLink(Name name) throws NamingException {
        if (name.isEmpty()) {
            return this;
        }
        String child = name.get(0);
        Object o = this.get(child);
        if (name.size() == 1) {
            if (o == null) {
                throw new NameNotFoundException(child);
            }
            return o;
        }
        if (o instanceof LinkRef) {
            o = this.resolveObject((LinkRef)o);
        }
        if (o instanceof Context) {
            return ((Context)o).lookupLink(name.getSuffix(1));
        }
        throw new NameNotFoundException(child);
    }

    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(nameParser.parse(name));
    }

    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name, obj, false);
    }

    public void rebind(Name name, Object obj, boolean intermediate) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("empty name");
        }
        String child = name.get(0);
        if (name.size() == 1) {
            this.put(child, obj);
            return;
        }
        Object o = this.get(child);
        if (o == null && intermediate) {
            o = new SimpleContext();
            this.put(child, o);
        }
        if (o instanceof SimpleContext) {
            ((SimpleContext)o).rebind(name.getSuffix(1), obj, intermediate);
            return;
        }
        throw new NameNotFoundException(child);
    }

    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(nameParser.parse(name), obj);
    }

    public void rebind(String name, Object obj, boolean intermediate) throws NamingException {
        this.rebind(nameParser.parse(name), obj, intermediate);
    }

    public void rename(Name oldName, Name newName) throws NamingException {
        if (oldName.isEmpty() || newName.isEmpty()) {
            throw new InvalidNameException("empty name");
        }
        Object obj = this.lookup(oldName);
        this.bind(newName, obj);
        this.unbind(oldName);
    }

    public void rename(String oldName, String newName) throws NamingException {
        Object obj = this.lookup(oldName);
        this.bind(newName, obj);
        this.unbind(oldName);
    }

    public void unbind(Name name) throws NamingException {
        if (name.isEmpty()) {
            throw new InvalidNameException("empty name");
        }
        String child = name.get(0);
        if (name.size() == 1) {
            this.remove(child);
            return;
        }
        Object o = this.get(child);
        if (o instanceof Context) {
            ((Context)o).unbind(name.getSuffix(1));
            return;
        }
        throw new NameNotFoundException(child);
    }

    public void unbind(String name) throws NamingException {
        this.unbind(nameParser.parse(name));
    }

    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        return this.environment.put(propName, propVal);
    }

    public Object removeFromEnvironment(String propName) throws NamingException {
        return this.environment.remove(propName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object resolveObject(LinkRef link) throws NamingException {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(SimpleContext.class.getClassLoader());
            InitialContext context = new InitialContext(this.environment);
            Object object = context.lookup(link.getLinkName());
            Object var6_5 = null;
            if (cl != null) {
                Thread.currentThread().setContextClassLoader(cl);
            }
            return object;
        }
        catch (Throwable throwable) {
            block3: {
                Object var6_6 = null;
                if (cl == null) break block3;
                Thread.currentThread().setContextClassLoader(cl);
            }
            throw throwable;
        }
    }

    class BindingEnum
    extends NamingEnum {
        BindingEnum(Hashtable bindings) {
            super(bindings);
        }

        public Object nextElement() {
            String name = (String)this.namesEnum.nextElement();
            return new Binding(name, this.bindings.get(name));
        }
    }

    class NamingEnum
    implements NamingEnumeration {
        protected Enumeration namesEnum;
        protected Hashtable bindings;

        NamingEnum(Hashtable bindings) {
            this.namesEnum = bindings.keys();
            this.bindings = bindings;
        }

        public boolean hasMoreElements() {
            return this.namesEnum.hasMoreElements();
        }

        public boolean hasMore() throws NamingException {
            return this.hasMoreElements();
        }

        public Object next() throws NamingException {
            return this.nextElement();
        }

        public Object nextElement() {
            String name = (String)this.namesEnum.nextElement();
            String className = this.bindings.get(name).getClass().getName();
            return new NameClassPair(name, className);
        }

        public void close() throws NamingException {
        }
    }

    static class SimpleNameParser
    implements NameParser {
        private static final Properties syntax = new Properties();

        SimpleNameParser() {
        }

        public Name parse(String name) throws NamingException {
            return new CompoundName(name, syntax);
        }

        static {
            syntax.put("jndi.syntax.direction", "left_to_right");
            syntax.put("jndi.syntax.separator", "/");
        }
    }
}

