/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.ntlm;

import com.day.j2ee.ntlm.NTLMCallContext;
import com.day.j2ee.ntlm.NTLMDomain;
import com.day.j2ee.servletengine.Constants;
import com.day.smb.SmbClient;
import com.day.smb.SmbException;
import com.day.smb.ntlm.Type1Message;
import com.day.smb.ntlm.Type2Message;
import com.day.smb.ntlm.Type3Message;
import java.net.InetAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DefaultNTLMDomain
implements NTLMDomain,
Constants {
    private static final Logger SEL = LoggerFactory.getLogger((String)"servletengine");
    private static final String CLIENT_ATTR_NAME = "smbclient";
    private final String name;
    private final String dnsDomain;
    private final InetAddress controller;

    public DefaultNTLMDomain(String name, InetAddress controller) {
        this.name = name;
        this.controller = controller;
        this.dnsDomain = DefaultNTLMDomain.getDnsDomain(controller);
    }

    public Type2Message challenge(NTLMCallContext callCtx, Type1Message in) throws SmbException {
        byte[] challenge = this.getChallenge(callCtx);
        Type2Message out = new Type2Message();
        out.setChallenge(challenge);
        out.setContext(new byte[8]);
        out.setDnsDomain(this.dnsDomain);
        out.setDomain(this.name);
        out.setFlags(-1602125307);
        out.setFqDnsHost(this.controller.getCanonicalHostName());
        out.setParentDomain(this.dnsDomain);
        out.setServer(this.controller.getHostName().toUpperCase());
        out.setTargetName(this.name);
        return out;
    }

    protected byte[] getChallenge(NTLMCallContext callCtx) throws SmbException {
        SmbClient client = (SmbClient)callCtx.getAttribute(CLIENT_ATTR_NAME);
        if (client != null) {
            client.close();
        }
        client = new SmbClient(this.controller);
        callCtx.setAttribute(CLIENT_ATTR_NAME, client);
        return client.negotiate();
    }

    public void validate(NTLMCallContext callCtx, Type3Message in) throws SmbException {
        SmbClient client = (SmbClient)callCtx.getAttribute(CLIENT_ATTR_NAME);
        client.setup(in.getUserName(), this.name, in.getNtlmResponse());
    }

    public void release(NTLMCallContext callCtx) {
        SmbClient client = (SmbClient)callCtx.getAttribute(CLIENT_ATTR_NAME);
        if (client != null) {
            client.close();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getDnsDomain() {
        return this.dnsDomain;
    }

    private static String getDnsDomain(InetAddress addr) {
        String hostaddr;
        String hostname = addr.getCanonicalHostName();
        if (hostname.equals(hostaddr = addr.getHostAddress())) {
            SEL.warn("Unable to determine hostname of {}.", (Object)hostaddr);
            return null;
        }
        int index = hostname.indexOf(46);
        if (index == -1) {
            SEL.warn("Unable to determine FQDN of {}.", (Object)hostaddr);
            return null;
        }
        return hostname.substring(index + 1);
    }
}

