/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.ntlm;

import com.day.j2ee.ntlm.AnonymousNTLMDomain;
import com.day.j2ee.ntlm.DefaultNTLMDomain;
import com.day.j2ee.ntlm.NTLMAuthenticationHandler;
import com.day.j2ee.ntlm.NTLMDomain;
import com.day.j2ee.servletengine.Constants;
import com.day.smb.netbios.NBClient;
import com.day.smb.netbios.NBException;
import com.day.smb.netbios.NBRecord;
import com.day.smb.netbios.Name;
import com.day.smb.netbios.UnknownNameException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NTLMAuthenticator
implements Constants {
    private static final Logger SEL = LoggerFactory.getLogger((String)"servletengine");
    private final NBClient nbClient;
    private AnonymousNTLMDomain anonymousDomain;
    private final Map domains = new HashMap();
    private boolean initialized;

    public NTLMAuthenticator() throws NBException, UnknownHostException {
        this.nbClient = new NBClient();
        Thread populator = new Thread(new Runnable(){

            public void run() {
                NTLMAuthenticator.this.init();
            }
        }, "Populator");
        populator.setDaemon(true);
        populator.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void init() {
        try {
            this.anonymousDomain = new AnonymousNTLMDomain(InetAddress.getLocalHost());
        }
        catch (UnknownHostException e) {
            SEL.warn("Unable to create anonymous domain: {}", (Object)e.getMessage());
        }
        try {
            this.populateDomains();
        }
        finally {
            this.initialized = true;
            this.notifyAll();
        }
    }

    private synchronized void ensureInitialized() {
        while (!this.initialized) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                SEL.warn("Interrupted while waiting for initialization: {}.", (Object)e.getMessage());
            }
        }
    }

    public void close() {
        if (this.nbClient != null) {
            this.nbClient.close();
        }
    }

    private void populateDomains() {
        InetAddress[] browsers;
        try {
            browsers = this.nbClient.query(Name.BROWSER_GROUP);
        }
        catch (UnknownNameException e) {
            SEL.debug("No master browsers registered in subnet.");
            return;
        }
        catch (NBException e) {
            SEL.warn("Unable to query master browsers: {}.", (Object)e.getMessage());
            return;
        }
        for (int i = 0; i < browsers.length; ++i) {
            NBRecord[] records;
            InetAddress browser = browsers[i];
            String hostname = browser.getCanonicalHostName();
            if (hostname.equals(browser.getHostAddress())) {
                SEL.debug("Unable to lookup canonical host name of {}.", (Object)hostname);
                continue;
            }
            try {
                records = this.nbClient.status(browser);
            }
            catch (UnknownNameException e) {
                SEL.debug("Master browser {} registered no names.", (Object)hostname);
                continue;
            }
            catch (NBException e) {
                SEL.warn("Unable to query names registered by {}.", (Object)hostname);
                continue;
            }
            for (int j = 0; j < records.length; ++j) {
                Name name = records[j].getName();
                int flags = records[j].getFlags();
                if ((flags & 0x8000) != 0 || name.getSuffix() != 27) continue;
                this.addDomain(name.getName(), browser);
            }
        }
    }

    private void addDomain(String name, InetAddress controller) {
        if (SEL.isDebugEnabled()) {
            SEL.debug("Registering domain: {}, controller: {}", (Object)name, (Object)controller.getCanonicalHostName());
        }
        this.domains.put(name, new DefaultNTLMDomain(name, controller));
    }

    public String getDomain(InetAddress workstation) throws NBException {
        NBRecord[] records = this.nbClient.status(workstation);
        for (int i = 0; i < records.length; ++i) {
            Name name = records[i].getName();
            int flags = records[i].getFlags();
            if ((flags & 0x8000) == 0 || name.getSuffix() != 0) continue;
            return name.getName();
        }
        throw new NBException("No workgroup name registered.");
    }

    public NTLMDomain getAnonymousDomain() {
        this.ensureInitialized();
        return this.anonymousDomain;
    }

    public NTLMDomain getDomain(String name) {
        this.ensureInitialized();
        return (NTLMDomain)this.domains.get(name);
    }

    public NTLMAuthenticationHandler createHandler() {
        return new NTLMAuthenticationHandler(this);
    }
}

