/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.portal;

import com.day.j2ee.config.ConfigException;
import com.day.j2ee.config.Param;
import com.day.j2ee.config.Servlet;
import com.day.j2ee.config.ServletMapping;
import com.day.j2ee.config.TagLib;
import com.day.j2ee.config.WebXml;
import com.day.j2ee.config.WebXmlReader;
import com.day.j2ee.config.WebXmlWriter;
import com.day.j2ee.portal.Portlet;
import com.day.j2ee.portal.PortletXml;
import com.day.j2ee.server.Server;
import com.day.j2ee.server.Util;
import com.day.j2ee.server.ZipCreator;
import com.day.j2ee.server.ZipExtractor;
import com.day.j2ee.servletengine.Constants;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Converter
implements Constants {
    private static final Logger SEL = LoggerFactory.getLogger((String)"servletengine");
    private static final String PORTLET_XML = "WEB-INF/portlet.xml";
    private static final String WEB_XML_FILE = "WEB-INF" + File.separator + "web.xml";
    private static final String PORTLET_XML_FILE = "WEB-INF" + File.separator + "portlet.xml";
    private static final String PORTLET_SERVLET_CLASS = "com.day.portlet.container.PortletServlet";
    private static final String PORTLET_TAGLIB_RESOURCE = "/resources/portlet.tld";
    private static final String PORTLET_TAGLIB_LOCATION = "/WEB-INF/tld/portlet.tld";
    private static final String PORTLET_TAGLIB_URI = "http://java.sun.com/portlet";
    private static final String PORTLET_LIBRARY_RESOURCE = "/resources/portlet-container.jar";
    private static final String PORTLET_LIBRARY_FILE = "/WEB-INF/lib/portlet-container.jar";
    private static final String INIT_PORTLET_CLASS = "portlet-class";
    private static final String INIT_PORTLET_NAME = "portlet-name";
    private final File file;
    private File tmpDir;
    private WebXml webXml;
    private PortletXml portletXml;

    private Converter(File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute() throws IOException, ConfigException {
        this.tmpDir = File.createTempFile("svr", null, Server.getTempDirectory());
        this.tmpDir.delete();
        this.tmpDir.mkdir();
        try {
            ZipExtractor.extract(this.file, this.tmpDir);
            this.loadWebXml();
            this.loadPortletXml();
            Iterator iter = this.portletXml.getPortlets().keySet().iterator();
            while (iter.hasNext()) {
                String portletName = (String)iter.next();
                Portlet portlet = this.portletXml.getPortlet(portletName);
                this.addPortletServlet(portlet);
            }
            this.addPortletTagLib();
            this.addFile(PORTLET_TAGLIB_RESOURCE, PORTLET_TAGLIB_LOCATION);
            this.addFile(PORTLET_LIBRARY_RESOURCE, PORTLET_LIBRARY_FILE);
            this.saveWebXml();
            ZipCreator.create(this.tmpDir, this.file);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            Util.rmdir(this.tmpDir);
            throw throwable;
        }
        Util.rmdir(this.tmpDir);
    }

    private void loadWebXml() throws IOException, ConfigException {
        File webXmlFile = new File(this.tmpDir, WEB_XML_FILE);
        this.webXml = webXmlFile.exists() ? WebXmlReader.parse(webXmlFile) : new WebXml(WebXml.Version.V2_3);
    }

    private void loadPortletXml() throws IOException, ConfigException {
        File portletXmlFile = new File(this.tmpDir, PORTLET_XML_FILE);
        FileInputStream in = new FileInputStream(portletXmlFile);
        try {
            try {
                this.portletXml = PortletXml.load(new InputSource(in));
            }
            catch (ParserConfigurationException e) {
                throw new ConfigException("Unable to parse portlet.xml", e);
            }
            catch (SAXException e) {
                throw new ConfigException("Unable to parse portlet.xml", e);
            }
            Object var5_3 = null;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            in.close();
            throw throwable;
        }
        in.close();
    }

    private void addPortletServlet(Portlet portlet) {
        Servlet servlet = new Servlet();
        servlet.setServletName(portlet.getPortletName());
        servlet.setServletClass(PORTLET_SERVLET_CLASS);
        servlet.addInitParam(new Param(INIT_PORTLET_CLASS, portlet.getPortletClass()));
        servlet.addInitParam(new Param(INIT_PORTLET_NAME, portlet.getPortletName()));
        this.webXml.addServlet(servlet);
        ServletMapping servletMapping = new ServletMapping();
        servletMapping.setServletName(portlet.getPortletName());
        servletMapping.setUrlPattern("/" + portlet.getPortletName() + "/*");
        this.webXml.addServletMapping(servletMapping);
    }

    private void addPortletTagLib() {
        TagLib tagLib = new TagLib(PORTLET_TAGLIB_LOCATION, PORTLET_TAGLIB_URI);
        this.webXml.addTagLib(tagLib);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addFile(String resourceName, String relativePath) throws IOException {
        InputStream in = null;
        try {
            in = this.getClass().getResourceAsStream(resourceName);
            if (in == null) {
                SEL.warn("Unable to add file to relative path {}: resource with name {} not found", (Object)relativePath, (Object)resourceName);
            } else {
                this.addFile(in, relativePath);
            }
            Object var5_4 = null;
            if (in == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (in == null) throw throwable;
            try {
                in.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            in.close();
            return;
        }
        catch (IOException e) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void addFile(InputStream in, String relativePath) throws IOException {
        String child = relativePath.replace('/', File.separatorChar);
        if (child.startsWith(File.separator)) {
            child = child.substring(1);
        }
        File destination = new File(this.tmpDir, child);
        destination.getParentFile().mkdirs();
        FileOutputStream out = null;
        try {
            int len;
            out = new FileOutputStream(destination);
            byte[] data = new byte[32768];
            while ((len = in.read(data)) > 0) {
                ((OutputStream)out).write(data, 0, len);
            }
            Object var9_8 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (out == null) throw throwable;
            try {
                ((OutputStream)out).close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            ((OutputStream)out).close();
            return;
        }
        catch (IOException e) {}
    }

    private void saveWebXml() throws IOException {
        File webXmlFile = new File(this.tmpDir, WEB_XML_FILE);
        WebXmlWriter.write(this.webXml, webXmlFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(File file) throws IOException, ConfigException {
        ZipFile zipFile = new ZipFile(file);
        boolean containsPortlets = false;
        try {
            ZipEntry entry = zipFile.getEntry(PORTLET_XML);
            if (entry != null && !entry.isDirectory()) {
                containsPortlets = true;
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            zipFile.close();
            throw throwable;
        }
        zipFile.close();
        if (containsPortlets) {
            new Converter(file).execute();
        }
    }
}

