/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.server;

import org.apache.log4j.Layout;
import org.apache.log4j.PatternLayout;

public class LogFile {
    private final com.day.j2ee.config.LogFile config;
    private LogFile defaultLogFile;

    public LogFile(com.day.j2ee.config.LogFile config) {
        this(config, null);
    }

    public LogFile(com.day.j2ee.config.LogFile config, LogFile defaultLogFile) {
        this.config = config;
        this.defaultLogFile = defaultLogFile;
    }

    public LogFile(String pattern, String filename, int maxBackupIndex, String maxFileSize) {
        this.config = new com.day.j2ee.config.LogFile();
        this.config.setPattern(pattern);
        this.config.setFilename(filename);
        this.config.setMaxBackupIndex(new Integer(maxBackupIndex));
        this.config.setMaxFileSize(maxFileSize);
    }

    public final String getPattern() {
        String pattern = this.config.getPattern();
        if (pattern == null && this.defaultLogFile != null) {
            pattern = this.defaultLogFile.getPattern();
        }
        return pattern;
    }

    public final Layout getLayout() {
        return new PatternLayout(this.getPattern());
    }

    public final String getFilename() {
        String filename = this.config.getFilename();
        if (filename == null && this.defaultLogFile != null) {
            filename = this.defaultLogFile.getFilename();
        }
        return filename;
    }

    public final String getMaxFileSize() {
        String maxFileSize = this.config.getMaxFileSize();
        if (maxFileSize == null && this.defaultLogFile != null) {
            maxFileSize = this.defaultLogFile.getMaxFileSize();
        }
        return maxFileSize;
    }

    public final int getMaxBackupIndex() {
        Integer maxBackupIndex = this.config.getMaxBackupIndex();
        if (maxBackupIndex == null && this.defaultLogFile != null) {
            maxBackupIndex = new Integer(this.defaultLogFile.getMaxBackupIndex());
        }
        return maxBackupIndex;
    }

    public void setDefaultLogFile(LogFile defaultLogFile) {
        this.defaultLogFile = defaultLogFile;
    }
}

