/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.server;

import com.day.j2ee.config.ConfigException;
import com.day.j2ee.config.ServerXml;
import com.day.j2ee.config.ServerXmlReader;
import com.day.j2ee.config.ServerXmlWriter;
import com.day.j2ee.server.LogFile;
import com.day.j2ee.server.Util;
import com.day.j2ee.servletengine.ServletEngine;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.AccessControlException;
import java.text.MessageFormat;
import java.util.Random;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.RollingFileAppender;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server
implements Runnable {
    private static final String DEF_SERVER_LOG_PATTERN = "%d{dd.MM.yyyy HH:mm:ss} *%-5p* %c{1}: %m%n";
    private static final String DEF_SERVER_LOG_MAX_FILE_SIZE = "10MB";
    private static final int DEF_SERVER_LOG_MAX_BACKUP_INDEX = 4;
    private static final Logger SRL = LoggerFactory.getLogger((String)"server");
    private static final String SERVER_CONFIG = "etc/server.xml";
    private static final String CQ3_SERVER_DIR = "cq3.bootstrap.server.dir";
    private static final int STDIN_POLL_DELAY = 1000;
    private static ServerXml config;
    private static long startTime;
    private static File homeDir;
    private static File tempDir;
    private static File runtimeDir;
    private static File webappsDir;
    private static File connectorsDir;
    private ServletEngine servletEngine;
    private Appender appender;
    private boolean started;
    private Random random;
    private Thread shutdownHook;

    public void init(String[] args) throws IOException, ConfigException {
        this.initConfig();
        Util.clean(Server.getTempDirectory());
        this.initLogger();
        if (config.getServletEngine() != null) {
            this.servletEngine = new ServletEngine(config.getServletEngine());
            this.servletEngine.init(args, this, Thread.currentThread().getContextClassLoader().getParent());
        }
    }

    protected void initConfig() throws IOException, ConfigException {
        homeDir = new File(System.getProperty(CQ3_SERVER_DIR, ".")).getCanonicalFile();
        this.loadConfig();
    }

    protected void loadConfig() throws IOException, ConfigException {
        File configFile = Server.getAbsolutePath(SERVER_CONFIG);
        config = ServerXmlReader.parse(configFile);
    }

    protected void saveConfig() throws IOException {
        File configFile = Server.getAbsolutePath(SERVER_CONFIG);
        ServerXmlWriter.write(config, configFile);
    }

    public static ServerXml getConfig() {
        return config;
    }

    public void configChanged() {
        try {
            this.saveConfig();
        }
        catch (IOException e) {
            SRL.error("Unable to save configuration: {}", (Object)e.getMessage());
        }
    }

    public void start() throws IOException {
        SRL.debug("Server start");
        if (this.servletEngine != null) {
            try {
                this.servletEngine.start();
                startTime = System.currentTimeMillis();
            }
            catch (IOException e) {
                SRL.error("Unable to start servlet engine: {}", (Object)e.getMessage());
                throw new IOException("servlet engine not running");
            }
        }
        this.started = true;
        try {
            Thread shutdownHook = new Thread(this);
            Runtime.getRuntime().addShutdownHook(shutdownHook);
            this.shutdownHook = shutdownHook;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        SRL.info("Server ready");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Server server = this;
        synchronized (server) {
            if (!this.started) {
                SRL.debug("Server already terminated");
                return;
            }
            this.started = false;
        }
        SRL.debug("Server stop");
        if (this.shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.servletEngine != null) {
            this.servletEngine.stop();
        }
        SRL.info("Server terminated");
    }

    public void run() {
        this.shutdownHook = null;
        SRL.debug("Shutting down on shutdown hook");
        this.stop();
    }

    public void awaitSocket() {
        ServerSocket serverSocket = null;
        try {
            serverSocket = new ServerSocket(config.getShutdownPort(), 1, InetAddress.getByName("127.0.0.1"));
        }
        catch (IOException e) {
            SRL.error("Server.awaitSocket: create[" + config.getShutdownPort() + "]: ", (Throwable)e);
            System.exit(1);
        }
        while (true) {
            int expected;
            Socket socket = null;
            InputStream stream = null;
            try {
                socket = serverSocket.accept();
                socket.setSoTimeout(10000);
                stream = socket.getInputStream();
            }
            catch (AccessControlException ace) {
                SRL.warn("Server.awaitSocket: accept security exception: " + ace.getMessage(), (Throwable)ace);
                continue;
            }
            catch (IOException e) {
                SRL.error("Server.awaitSocket: accept: ", (Throwable)e);
                System.exit(1);
            }
            StringBuffer command = new StringBuffer();
            for (expected = 1024; expected < config.getShutdownCommand().length(); expected += this.random.nextInt() % 1024) {
                if (this.random != null) continue;
                this.random = new Random(System.currentTimeMillis());
            }
            while (expected > 0) {
                int ch;
                try {
                    ch = stream.read();
                }
                catch (IOException e) {
                    SRL.warn("Server.awaitSocket: read: ", (Throwable)e);
                    ch = -1;
                }
                if (ch < 32) break;
                command.append((char)ch);
                --expected;
            }
            try {
                socket.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            boolean match = command.toString().equals(config.getShutdownCommand());
            if (match) break;
            SRL.warn("Server.awaitSocket: Invalid command '" + command.toString() + "' received");
        }
        try {
            serverSocket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        SRL.debug("Shutting down on quit from socket");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitStdIn() {
        try {
            byte[] data;
            int len;
            do {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            } while (System.in.available() <= 0 || (len = System.in.read(data = new byte[256])) < 4 || data[0] != 113 && data[0] != 81 || data[1] != 117 && data[1] != 85 || data[2] != 105 && data[2] != 73 || data[3] != 116 && data[3] != 84);
            SRL.debug("Shutting down on quit from stdin");
        }
        catch (IOException ioe) {
            Server server = this;
            synchronized (server) {
                while (true) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
        }
    }

    public void await(String[] args) {
        boolean shutdownSocket = false;
        int i = 0;
        while (i < args.length) {
            String param;
            if (!"-X".equals(args[i++]) || i >= args.length) continue;
            if ("shutdown:Socket".equals(param = args[i++])) {
                shutdownSocket = true;
                continue;
            }
            if (!"shutdown:StdIn".equals(param)) continue;
            shutdownSocket = false;
        }
        if (shutdownSocket) {
            SRL.debug("Listening for shutdown command on configured port");
            this.awaitSocket();
        } else {
            SRL.debug("Listening for shutdown command on StdIn");
            this.awaitStdIn();
        }
    }

    public void shutdown() throws IOException {
        Socket socket = new Socket("127.0.0.1", config.getShutdownPort());
        OutputStream stream = socket.getOutputStream();
        String shutdown = config.getShutdownCommand();
        for (int i = 0; i < shutdown.length(); ++i) {
            stream.write(shutdown.charAt(i));
        }
        stream.flush();
        stream.close();
        socket.close();
    }

    protected void initLogger() throws IOException {
        String logFilename;
        LogFile lf = new LogFile(DEF_SERVER_LOG_PATTERN, null, 4, DEF_SERVER_LOG_MAX_FILE_SIZE);
        if (config.getLogFile() != null) {
            lf = new LogFile(config.getLogFile(), lf);
        }
        this.appender = (logFilename = lf.getFilename()) == null ? new ConsoleAppender(lf.getLayout()) : this.createFileAppender(lf);
        org.apache.log4j.Logger root = LogManager.getRootLogger();
        root.addAppender(this.appender);
        root.setLevel(Level.toLevel((String)config.getLogLevel(), (Level)Level.WARN));
    }

    private final RollingFileAppender createFileAppender(LogFile lf) throws IOException {
        RollingFileAppender logAppender;
        File logFile = Server.getAbsolutePath(lf.getFilename());
        logFile.getParentFile().mkdirs();
        try {
            logAppender = new RollingFileAppender((Layout)new PatternLayout(lf.getPattern()), logFile.getPath(), true);
        }
        catch (IOException e) {
            throw new IOException(MessageFormat.format("unable to open log file {0}: {1}", logFile.getPath(), e.getMessage()));
        }
        logAppender.setMaxBackupIndex(lf.getMaxBackupIndex());
        logAppender.setMaxFileSize(lf.getMaxFileSize());
        return logAppender;
    }

    private static void doShutdown(String[] args) throws IOException, ConfigException {
        if (args.length != 1 || !"stop".equals(args[0])) {
            return;
        }
        Server server = new Server();
        server.initConfig();
        server.shutdown();
        System.exit(0);
    }

    public static void main(String[] args) {
        try {
            Server.doShutdown(args);
            Server server = new Server();
            server.init(args);
            server.start();
            server.await(args);
            server.stop();
            SRL.debug("Exiting VM now");
            System.exit(0);
        }
        catch (FileNotFoundException e) {
            System.err.println("Unable to start or stop server: file not found: " + e.getMessage());
        }
        catch (IOException e) {
            System.err.println("Unable to start or stop server: I/O error: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            System.err.println("Unable to start server: " + e.getMessage());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public static File getHomeDirectory() {
        return homeDir;
    }

    public static void setHomeDirectory(File homeDir) {
        if (Server.homeDir == null) {
            Server.homeDir = homeDir;
        }
    }

    public static File getTempDirectory() {
        if (tempDir == null && !(tempDir = Server.getAbsolutePath(System.getProperty("server.tmp", "tmp"))).exists()) {
            tempDir.mkdirs();
        }
        return tempDir;
    }

    public static File getRuntimeDirectory() {
        if (runtimeDir == null && !(runtimeDir = Server.getAbsolutePath("runtime")).exists()) {
            runtimeDir.mkdirs();
        }
        return runtimeDir;
    }

    public static File getWebappsDirectory() {
        if (webappsDir == null && !(webappsDir = Server.getAbsolutePath("webapps")).exists()) {
            webappsDir.mkdirs();
        }
        return webappsDir;
    }

    public static File getConnectorsDirectory() {
        if (connectorsDir == null && !(connectorsDir = Server.getAbsolutePath("connectors")).exists()) {
            connectorsDir.mkdirs();
        }
        return connectorsDir;
    }

    public static File getAbsolutePath(String path) {
        File file = new File(path.replace('/', File.separatorChar));
        if (!file.isAbsolute()) {
            file = new File(Server.getHomeDirectory(), file.getPath());
        }
        return file;
    }

    public static String getRelativePath(File file) {
        String relPath = file.getPath();
        if (file.isAbsolute()) {
            String homeDir = Server.getHomeDirectory().getAbsolutePath();
            String filePath = file.getAbsolutePath();
            if (filePath.startsWith(homeDir) && (relPath = filePath.substring(homeDir.length())).startsWith(File.separator)) {
                relPath = relPath.substring(1);
            }
        }
        return relPath.replace(File.separatorChar, '/');
    }

    public static long getStartTime() {
        return startTime;
    }
}

