/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.servletengine;

import com.day.j2ee.config.Filter;
import com.day.j2ee.config.Param;
import com.day.j2ee.servletengine.WebApplication;
import com.day.util.IteratorEnumeration;
import java.util.Enumeration;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.slf4j.Logger;

class FilterRuntimeEnvironment
implements FilterConfig {
    private final Filter config;
    private javax.servlet.Filter filter;
    private final WebApplication application;
    private final Logger logger;

    public FilterRuntimeEnvironment(WebApplication application, Filter config) {
        this.application = application;
        this.logger = application.getLogger();
        this.config = config;
    }

    public void start() throws ServletException {
        this.logger.debug("Start Filter '{}'", (Object)this.getFilterName());
        ClassLoader loader = this.application.getLoader();
        Object o = null;
        try {
            try {
                o = this.application.enter();
                Class<?> filterClass = loader.loadClass(this.config.getFilterClass());
                this.filter = (javax.servlet.Filter)filterClass.newInstance();
                this.filter.init(this);
            }
            catch (ServletException e) {
                this.filter = null;
                throw e;
            }
            catch (Throwable e) {
                this.filter = null;
                throw new ServletException("Unable to create filter", e);
            }
            Object var5_6 = null;
            this.application.exit(o);
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.application.exit(o);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.logger.debug("Stop filter '{}'", (Object)this.getFilterName());
        Object o = null;
        try {
            o = this.application.enter();
            if (this.filter != null) {
                this.filter.destroy();
                this.filter = null;
            }
            Object var3_2 = null;
            this.application.exit(o);
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.application.exit(o);
            throw throwable;
        }
    }

    public javax.servlet.Filter getFilter() {
        return this.filter;
    }

    public ServletContext getServletContext() {
        return this.application;
    }

    public String getInitParameter(String name) {
        Param initParam = this.config.getInitParam(name);
        if (initParam != null) {
            return initParam.getParamValue();
        }
        return null;
    }

    public Enumeration getInitParameterNames() {
        return new IteratorEnumeration(this.config.initParamNames());
    }

    public String getFilterName() {
        return this.config.getFilterName();
    }
}

