/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.servletengine;

import com.day.j2ee.servletengine.Constants;
import com.day.j2ee.servletengine.HttpSessionImpl;
import com.day.j2ee.servletengine.WebApplication;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpSessionEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HttpSessionManager
implements Constants {
    private final int defaultTimeout;
    private final Map sessions = new HashMap();
    private static final Logger SEL = LoggerFactory.getLogger((String)"servletengine");
    private static final int DEFAULT_SESSION_TIMEOUT = 600;
    private static final int REAPER_RUN_DELAY = 60000;
    volatile boolean closed;
    private final Thread reaper;

    public HttpSessionManager() {
        this(600);
    }

    public HttpSessionManager(int defaultTimeout) {
        this.defaultTimeout = defaultTimeout;
        this.reaper = new Thread(new Runnable(){

            public void run() {
                while (!HttpSessionManager.this.closed) {
                    try {
                        Thread.sleep(60000L);
                        HttpSessionManager.this.removeOutdatedSessions();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }, "SessionManager.Reaper");
        this.reaper.setDaemon(true);
        this.reaper.setPriority(1);
        this.reaper.start();
    }

    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.reaper.interrupt();
            try {
                this.reaper.join(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpSessionImpl getSession(String id) {
        Map map = this.sessions;
        synchronized (map) {
            HttpSessionImpl session = (HttpSessionImpl)this.sessions.get(id);
            if (session != null) {
                if (!session.isValid()) {
                    SEL.debug("session with id {} invalid, removed", (Object)id);
                    this.sessions.remove(id);
                    session = null;
                } else {
                    SEL.debug("session with id {} valid", (Object)id);
                    session.touch();
                }
            } else {
                SEL.debug("no session with id {} found", (Object)id);
            }
            return session;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpSessionImpl createSession(WebApplication application, String sessionid) {
        Map map = this.sessions;
        synchronized (map) {
            Integer timeoutMinutes = application.getDefaultTimeout();
            boolean httpOnly = application.getHttpOnlyFlag();
            HttpSessionImpl session = new HttpSessionImpl(this, application, timeoutMinutes != null ? timeoutMinutes * 60 : this.defaultTimeout, httpOnly, sessionid);
            this.sessions.put(session.getId(), session);
            application.sessionCreated(new HttpSessionEvent(session));
            return session;
        }
    }

    public HttpSessionImpl createSession(WebApplication application) {
        return this.createSession(application, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateSessions(WebApplication application) {
        Map map = this.sessions;
        synchronized (map) {
            Iterator iter = this.sessions.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                HttpSessionImpl session = (HttpSessionImpl)entry.getValue();
                if (session.getApplication() != application) continue;
                session.destroy();
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidateSession(HttpSessionImpl session) {
        Map map = this.sessions;
        synchronized (map) {
            session.destroy();
            session.setInvalid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeOutdatedSessions() {
        SEL.debug("session scanning started...");
        Map map = this.sessions;
        synchronized (map) {
            Iterator iter = this.sessions.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                HttpSessionImpl session = (HttpSessionImpl)entry.getValue();
                if (session.isValid()) continue;
                iter.remove();
            }
        }
        SEL.debug("session scanning ended.");
    }
}

