/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.servletengine;

import com.day.j2ee.config.ConfigException;
import com.day.j2ee.config.Key;
import com.day.j2ee.config.Listener;
import com.day.j2ee.config.SSL;
import com.day.j2ee.server.Server;
import com.day.j2ee.servletengine.HttpListener;
import com.day.j2ee.servletengine.SingleKeyStore;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.interfaces.RSAPrivateKey;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class HttpsListener
extends HttpListener {
    private static final String PROVIDER = "com.sun.net.ssl.internal.ssl.Provider";
    private SSLServerSocketFactory sslProxy;
    protected String protocol = "SSL";
    protected String algorithm = "SunX509";
    private File keyStoreFile = new File(System.getProperty("user.home") + File.separator + ".keystore");
    private String keyStoreType = "JKS";
    protected String keyStorePass = "";
    protected String keyAlias = "mykey";
    protected String keyPass = "";
    protected KeyStore keyStore;

    public void loadFromConfig(Listener config) throws ConfigException {
        super.loadFromConfig(config);
        SSL ssl = config.getSSL();
        if (ssl.getProtocol() != null) {
            this.protocol = ssl.getProtocol();
        }
        if (ssl.getKeyStore() != null) {
            com.day.j2ee.config.KeyStore keyStore = ssl.getKeyStore();
            if (keyStore.getAlgorithm() != null) {
                this.algorithm = keyStore.getAlgorithm();
            }
            if (keyStore.getType() != null) {
                this.keyStoreType = keyStore.getType();
            }
            if (keyStore.getName() != null) {
                this.keyStoreFile = Server.getAbsolutePath(keyStore.getName());
            }
            if (keyStore.getPassphrase() != null) {
                this.keyStorePass = keyStore.getPassphrase();
            }
        }
        if (ssl.getKey() != null) {
            Key key = ssl.getKey();
            if (key.getAlias() != null) {
                this.keyAlias = key.getAlias();
            }
            if (key.getPassword() != null) {
                this.keyPass = key.getPassword();
            }
        }
    }

    protected ServerSocket startServer() throws IOException {
        if (this.sslProxy == null) {
            this.initialize();
        }
        if (this.host != null) {
            this.addr = InetAddress.getByName(this.host);
        }
        ServerSocket server = this.sslProxy.createServerSocket(this.port, this.backlog, this.addr);
        this.initServerSocket(server);
        server.setSoTimeout(60000);
        return server;
    }

    public String getScheme() {
        return "https";
    }

    protected synchronized void initialize() throws IOException {
        this.initKeyStore();
        this.initProxy();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void initKeyStore() throws IOException {
        FileInputStream istream = null;
        try {
            try {
                this.keyStore = KeyStore.getInstance(this.keyStoreType);
                istream = new FileInputStream(this.keyStoreFile);
                this.keyStore.load(istream, this.keyStorePass.toCharArray());
                java.security.Key key = this.keyStore.getKey(this.keyAlias, this.keyPass.toCharArray());
                if (key == null) {
                    SEL.error("Alias '{}' not found in {}", (Object)this.keyAlias, (Object)this.keyStoreFile);
                    throw new IllegalArgumentException("Bad SSL Configuration");
                }
                if (!(key instanceof RSAPrivateKey)) {
                    SEL.error("Key '{}' should be of type RSA", (Object)this.keyAlias);
                    throw new IllegalArgumentException("Bad SSL Configuration");
                }
                this.keyStore = new SingleKeyStore(this.keyStore, this.keyAlias);
            }
            catch (FileNotFoundException e) {
                SEL.error("Key store file not found: {}", (Object)this.keyStoreFile);
                throw new IllegalArgumentException("Bad SSL Configuration");
            }
            catch (UnrecoverableKeyException e) {
                SEL.error("Key '{}' unrecoverable: {}", (Object)this.keyAlias, (Object)e.getMessage());
                throw new IllegalArgumentException("Bad SSL Configuration");
            }
            catch (NoSuchAlgorithmException e) {
                SEL.error("No such algorithm: {}", (Object)e.getMessage());
                throw new IllegalArgumentException("Bad SSL Configuration");
            }
            catch (KeyStoreException e) {
                SEL.error("Key store failure: {}", (Object)e.getMessage());
                throw new IllegalArgumentException("Bad SSL Configuration");
            }
            catch (CertificateException e) {
                SEL.error("Certificate failure: {}", (Object)e.getMessage());
                throw new IllegalArgumentException("Bad SSL Configuration");
            }
            Object var4_8 = null;
            if (istream == null) return;
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            if (istream == null) throw throwable;
            try {
                istream.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        istream.close();
        return;
    }

    protected void initProxy() throws IOException {
        try {
            try {
                Security.addProvider((Provider)Class.forName(PROVIDER).newInstance());
            }
            catch (Throwable t) {
                // empty catch block
            }
            SSLContext context = SSLContext.getInstance(this.protocol);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this.algorithm);
            keyManagerFactory.init(this.keyStore, this.keyPass.toCharArray());
            KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
            context.init(keyManagers, null, new SecureRandom());
            this.sslProxy = context.getServerSocketFactory();
        }
        catch (NoSuchAlgorithmException e) {
            SEL.error("No such algorithm: {}", (Object)e.getMessage());
            throw new IllegalArgumentException("Bad SSL Configuration");
        }
        catch (KeyStoreException e) {
            SEL.error("Key store failure: {}", (Object)e.getMessage());
            throw new IllegalArgumentException("Bad SSL Configuration");
        }
        catch (KeyManagementException e) {
            SEL.error("Key management failure: {}", (Object)e.getMessage());
            throw new IllegalArgumentException("Bad SSL Configuration");
        }
        catch (UnrecoverableKeyException e) {
            SEL.error("Unrecoverable key: {}", (Object)e.getMessage());
            throw new IllegalArgumentException("Bad SSL Configuration");
        }
        catch (RuntimeException e) {
            SEL.error("Unexpected exception:", (Throwable)e);
            throw new IllegalArgumentException("Bad SSL Configuration");
        }
    }

    protected void initServerSocket(ServerSocket ssocket) {
        SSLServerSocket socket = (SSLServerSocket)ssocket;
        String[] cipherSuites = socket.getSupportedCipherSuites();
        socket.setEnabledCipherSuites(cipherSuites);
    }

    public void setKeyStore(String keyStore) {
        this.keyStoreFile = new File(keyStore);
    }

    public void setKeyStorePass(String keyStorePass) {
        this.keyStorePass = keyStorePass;
    }

    public void setKeyAlias(String keyAlias) {
        this.keyAlias = keyAlias;
    }

    public void setKeyPass(String keyPass) {
        this.keyPass = keyPass;
    }
}

