/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.servletengine;

import com.day.j2ee.servletengine.BoundedInputStream;
import com.day.j2ee.servletengine.ChunkedBodyInputStream;
import com.day.j2ee.servletengine.Constants;
import com.day.j2ee.servletengine.ServletHandlerImpl;
import com.day.j2ee.servletengine.ServletInputStreamImpl;
import com.day.j2ee.servletengine.URLPath;
import com.day.j2ee.servletengine.Util;
import com.day.j2ee.servletengine.WebApplication;
import com.day.util.IteratorEnumeration;
import com.day.util.Text;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Stack;
import javax.security.cert.X509Certificate;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestImpl
implements HttpServletRequest,
Constants {
    private static final Logger SEL = LoggerFactory.getLogger((String)"servletengine");
    private static final int MAX_PARAMETER_COUNT = 10000;
    private static final InputStream EMPTY_INPUT_STREAM = new InputStream(){

        public int read() {
            return -1;
        }
    };
    private final ServletHandlerImpl handler;
    private final Map attributes = new HashMap();
    private Map parameters;
    private Util.LanguageTag[] languageTags;
    private Locale locale;
    private Locale[] locales;
    private final Stack paramStack = new Stack();
    private final List cookies = new ArrayList();
    private InputStream in;
    private InputStream filterIn;
    private ServletInputStream servletIn;
    private BufferedReader reader;
    private boolean sessionIdInsideParameters;
    private boolean sessionIdInsideCookies;
    private boolean sessionIdChecked;
    private String sessionId;
    private String characterEncoding;
    private boolean characterEncodingChecked;
    private long contentLength;
    private boolean contentLengthChecked;
    private URLPath urlPath;
    private String authType;
    private Principal userPrincipal;
    private WebApplication application;
    private boolean keepAliveDisabled;
    private Logger logger;
    private boolean trace;
    private boolean isSecureRequest;
    private String serverName;
    private int serverPort;

    public RequestImpl(ServletHandlerImpl handler) {
        this.handler = handler;
    }

    public void attach(InputStream in) throws IOException {
        this.in = in;
    }

    public void setURLPath(URLPath urlPath) {
        this.urlPath = urlPath;
    }

    public WebApplication getApplication() {
        return this.application;
    }

    public void setApplication(WebApplication application) {
        this.application = application;
        this.logger = application.getLogger();
        this.trace = this.logger.isTraceEnabled();
    }

    protected void finish() {
        if (this.filterIn == null) {
            if (this.hasChunkedBody()) {
                this.filterIn = new ChunkedBodyInputStream(this, this.in);
            } else {
                long contentLength = this.getContentLengthLong();
                if (contentLength > 0L) {
                    this.filterIn = new BoundedInputStream(this, this.in, contentLength);
                }
            }
        }
        if (this.servletIn != null) {
            try {
                this.servletIn.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.servletIn = null;
        }
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            this.reader = null;
        }
        if (this.filterIn != null) {
            try {
                this.filterIn.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.filterIn = null;
        }
    }

    public void recycle() {
        this.attributes.clear();
        this.cookies.clear();
        this.parameters = null;
        this.locales = null;
        this.locale = null;
        this.languageTags = null;
        this.characterEncodingChecked = false;
        this.contentLengthChecked = false;
        this.sessionIdChecked = false;
        this.sessionIdInsideParameters = false;
        this.sessionIdInsideCookies = false;
        this.keepAliveDisabled = false;
        this.authType = null;
        this.userPrincipal = null;
        this.serverName = null;
        this.serverPort = -1;
        this.isSecureRequest = this.handler.isSecure();
        if (this.isSecureRequest) {
            this.setAttribute("javax.servlet.request.cipher_suite", this.handler.getCipherSuite(), false);
            this.setAttribute("javax.servlet.request.key_size", new Integer(this.handler.getSSLKeyLength()), false);
            X509Certificate[] certChain = this.handler.getCertificateChain();
            if (certChain != null) {
                this.setAttribute("javax.servlet.request.X509Certificate", certChain, false);
            }
        }
    }

    public void reset() {
    }

    public void pushParameters(String queryString) {
        if (this.parameters == null) {
            String encoding = this.getCharacterEncoding();
            if (encoding == null) {
                encoding = "8859_1";
            }
            this.parameters = this.processParameters(encoding);
        }
        this.paramStack.push(this.parameters);
        if (queryString != null) {
            this.parameters = (Map)((HashMap)this.parameters).clone();
            this.combineParameters(queryString, this.parameters);
        }
    }

    public void popParameters() {
        if (!this.paramStack.isEmpty()) {
            this.parameters = (Map)this.paramStack.pop();
        }
    }

    public String getAuthType() {
        if (this.trace) {
            this.logger.trace("getAuthType");
        }
        return this.authType;
    }

    public Cookie[] getCookies() {
        List values;
        if (this.trace) {
            this.logger.trace("getCookies");
        }
        if (this.cookies.size() == 0 && (values = this.handler.getHeaders("cookie")) != null) {
            for (int i = 0; i < values.size(); ++i) {
                String cookieString = (String)values.get(i);
                try {
                    byte[] data = cookieString.getBytes("8859_1");
                    Util.parseCookies(data, this.cookies);
                    continue;
                }
                catch (UnsupportedEncodingException e) {
                    SEL.error("Unable to parse request cookie string '{}': ISO-8859-1 encoding unsupported", (Object)cookieString);
                    continue;
                }
                catch (IllegalArgumentException e) {
                    SEL.error("Unable to parse request cookie string '{}': {}", (Object)cookieString, (Object)e.getMessage());
                }
            }
        }
        if (this.cookies.size() > 0) {
            Cookie[] result = new Cookie[this.cookies.size()];
            this.cookies.toArray(result);
            return result;
        }
        return null;
    }

    public long getDateHeader(String name) {
        String value;
        if (this.trace) {
            this.logger.trace("getDateHeader({})", (Object)name);
        }
        if ((value = this.getHeader(name)) != null) {
            return Util.parse(value).getTime();
        }
        return -1L;
    }

    public String getHeader(String name) {
        List list;
        if (this.trace) {
            this.logger.trace("getHeader({})", (Object)name);
        }
        if ((list = this.handler.getHeaders(name)) != null) {
            return (String)list.get(0);
        }
        return null;
    }

    public Enumeration getHeaders(String name) {
        List list;
        if (this.trace) {
            this.logger.trace("getHeaders({})", (Object)name);
        }
        if ((list = this.handler.getHeaders(name)) != null) {
            return Collections.enumeration(list);
        }
        return Collections.enumeration(Collections.EMPTY_LIST);
    }

    public Enumeration getHeaderNames() {
        if (this.trace) {
            this.logger.trace("getHeaderNames");
        }
        return new IteratorEnumeration(this.handler.getHeaderNames());
    }

    public int getIntHeader(String name) {
        String value;
        if (this.trace) {
            this.logger.trace("getIntHeader({})", (Object)name);
        }
        if ((value = this.getHeader(name)) != null) {
            return Integer.parseInt(value);
        }
        return -1;
    }

    public String getMethod() {
        if (this.trace) {
            this.logger.trace("getMethod");
        }
        return this.handler.getMethod();
    }

    public String getPathInfo() {
        if (this.trace) {
            this.logger.trace("getPathInfo");
        }
        return this.urlPath.getPathInfo();
    }

    public String getPathTranslated() {
        String pathInfo;
        if (this.trace) {
            this.logger.trace("getPathTranslated");
        }
        if ((pathInfo = this.getPathInfo()) == null) {
            return pathInfo;
        }
        return this.application.getRealPath(pathInfo);
    }

    public String getContextPath() {
        if (this.trace) {
            this.logger.trace("getContextPath");
        }
        return this.urlPath.getContextPath();
    }

    public String getQueryString() {
        if (this.trace) {
            this.logger.trace("getQueryString");
        }
        return this.urlPath.getQueryString();
    }

    public String getRemoteUser() {
        if (this.trace) {
            this.logger.trace("getRemoteUser");
        }
        return this.userPrincipal != null ? this.userPrincipal.getName() : null;
    }

    public boolean isUserInRole(String role) {
        if (this.trace) {
            this.logger.trace("isUserInRole({})", (Object)role);
        }
        return false;
    }

    public Principal getUserPrincipal() {
        if (this.trace) {
            this.logger.trace("getUserPrincipal");
        }
        return this.userPrincipal;
    }

    public void setUserPrincipal(Principal userPrincipal, String authType) {
        this.userPrincipal = userPrincipal;
        this.authType = authType;
    }

    public String getRequestedSessionId() {
        HttpSession session;
        if (this.trace) {
            this.logger.trace("getRequestedSessionId");
        }
        if ((session = this.getSession(false)) != null) {
            return session.getId();
        }
        return null;
    }

    public String getRequestURI() {
        if (this.trace) {
            this.logger.trace("getRequestURI");
        }
        return this.urlPath.getRequestURI();
    }

    public StringBuffer getRequestURL() {
        if (this.trace) {
            this.logger.trace("getRequestURL");
        }
        String scheme = this.getScheme();
        int port = this.getServerPort();
        StringBuffer b = new StringBuffer(256);
        b.append(scheme);
        b.append("://");
        b.append(this.getServerName());
        if (scheme.equals("http") && port != 80 || scheme.equals("https") && port != 443) {
            b.append(':');
            b.append(port);
        }
        b.append(this.getRequestURI());
        return b;
    }

    public String getServletPath() {
        if (this.trace) {
            this.logger.trace("getServletPath");
        }
        return this.urlPath.getServletPath();
    }

    public HttpSession getSession(boolean create) {
        if (this.trace) {
            this.logger.trace("getSession({})", (Object)new Boolean(create));
        }
        return this.handler.getSession(create);
    }

    public HttpSession getSession() {
        if (this.trace) {
            this.logger.trace("getSession");
        }
        return this.getSession(true);
    }

    public String getSessionId() {
        if (!this.sessionIdChecked) {
            String sessionId = null;
            Cookie[] cookies = this.getCookies();
            if (cookies != null) {
                for (int i = 0; i < cookies.length; ++i) {
                    Cookie cookie = cookies[i];
                    if (!cookie.getName().equals("JSESSIONID")) continue;
                    sessionId = cookie.getValue();
                    this.sessionIdInsideCookies = true;
                    break;
                }
            }
            if (sessionId == null && (sessionId = this.urlPath.getPathSessionId()) != null) {
                this.sessionIdInsideParameters = true;
            }
            this.sessionId = sessionId;
            this.sessionIdChecked = true;
        }
        return this.sessionId;
    }

    public boolean isRequestedSessionIdValid() {
        HttpSession session;
        if (this.trace) {
            this.logger.trace("isRequestedSessionIdValid");
        }
        if ((session = this.getSession(false)) != null) {
            try {
                return session.getId() != null;
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        if (this.trace) {
            this.logger.trace("isRequestedSessionIdFromCookie");
        }
        this.getSessionId();
        return this.sessionIdInsideCookies;
    }

    public boolean isRequestedSessionIdFromURL() {
        if (this.trace) {
            this.logger.trace("isRequestedSessionIdFromURL");
        }
        this.getSessionId();
        return this.sessionIdInsideParameters;
    }

    public boolean isRequestedSessionIdFromUrl() {
        if (this.trace) {
            this.logger.trace("isRequestedSessionIdFromUrl");
        }
        return this.isRequestedSessionIdFromURL();
    }

    public Object getAttribute(String name) {
        if (this.trace) {
            this.logger.trace("getAttribute({})", (Object)name);
        }
        return this.attributes.get(name);
    }

    public Enumeration getAttributeNames() {
        if (this.trace) {
            this.logger.trace("getAttributeNames");
        }
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getCharacterEncoding() {
        if (this.trace) {
            this.logger.trace("getCharacterEncoding");
        }
        if (!this.characterEncodingChecked) {
            int start;
            this.characterEncoding = null;
            String contentType = this.getContentType();
            if (contentType != null && (start = contentType.indexOf("charset=")) != -1) {
                int end = contentType.indexOf(";", start += "charset=".length());
                if (end == -1) {
                    end = contentType.length();
                }
                this.characterEncoding = contentType.substring(start, end).trim();
            }
            this.characterEncodingChecked = true;
        }
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String enc) throws UnsupportedEncodingException {
        if (this.trace) {
            this.logger.trace("setCharacterEncoding({})", (Object)enc);
        }
        new String(new byte[]{88}, enc);
        this.characterEncoding = enc;
        this.characterEncodingChecked = true;
    }

    public int getContentLength() {
        long cl;
        if (this.trace) {
            this.logger.trace("getContentLength");
        }
        if ((cl = this.getContentLengthLong()) >= 0L && cl <= Integer.MAX_VALUE) {
            return (int)cl;
        }
        return -1;
    }

    private long getContentLengthLong() {
        if (!this.contentLengthChecked) {
            this.contentLength = -1L;
            String contentLength = this.getHeader("Content-Length");
            if (contentLength != null) {
                try {
                    this.contentLength = Long.parseLong(contentLength);
                }
                catch (RuntimeException runtimeException) {
                    // empty catch block
                }
            }
            this.contentLengthChecked = true;
        }
        return this.contentLength;
    }

    public String getContentType() {
        if (this.trace) {
            this.logger.trace("getContentType");
        }
        return this.getHeader("Content-Type");
    }

    public ServletInputStream getInputStream() throws IOException {
        if (this.trace) {
            this.logger.trace("getInputStream");
        }
        if (this.servletIn == null) {
            if (this.reader != null) {
                throw new IllegalStateException("getReader() already called");
            }
            if (this.filterIn == null) {
                long contentLength;
                this.filterIn = this.hasChunkedBody() ? new ChunkedBodyInputStream(this, this.in) : ((contentLength = this.getContentLengthLong()) == -1L ? EMPTY_INPUT_STREAM : new BoundedInputStream(this, this.in, contentLength));
            }
            this.servletIn = new ServletInputStreamImpl(new BufferedInputStream(this.filterIn));
        }
        return this.servletIn;
    }

    private byte[] getFormData() throws IOException, IllegalArgumentException {
        int chunk;
        if (this.hasChunkedBody()) {
            this.filterIn = new ChunkedBodyInputStream(this, this.in);
            return ((ChunkedBodyInputStream)this.filterIn).getData();
        }
        long cl = this.getContentLengthLong();
        if (cl == -1L) {
            return null;
        }
        if (cl > Integer.MAX_VALUE) {
            String msg = "Content length too big: " + cl;
            throw new IllegalArgumentException(msg);
        }
        int length = (int)cl;
        this.filterIn = new BoundedInputStream(this, this.in, length);
        byte[] data = new byte[length];
        for (int read = 0; read < length && (chunk = this.filterIn.read(data, read, length - read)) != -1; read += chunk) {
        }
        return data;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Map processParameters(String encoding) {
        LinkedHashMap parameters = new LinkedHashMap();
        try {
            byte[] data;
            int index;
            String queryString = this.getQueryString();
            if (queryString != null) {
                byte[] data2 = queryString.getBytes("8859_1");
                Util.parseQueryString(data2, encoding, parameters, false, -1);
            }
            String method = this.getMethod();
            String contentType = this.getContentType();
            if (contentType != null && (index = contentType.indexOf(59)) != -1) {
                contentType = contentType.substring(0, index).trim();
            }
            if (method.equals("POST") && "application/x-www-form-urlencoded".equals(contentType) && (data = this.getFormData()) != null) {
                Util.parseQueryString(data, encoding, parameters, false, 10000);
            }
            if (method.equals("POST") && !"multipart/form-data".equals(contentType)) return parameters;
        }
        catch (UnsupportedEncodingException e) {
            SEL.error("Unable to parse process parameters: ISO-8859-1 encoding unsupported");
            return parameters;
        }
        catch (IOException e) {
            SEL.error("Unable to process parameters: {}", (Object)e.getMessage());
            return parameters;
        }
        catch (IllegalArgumentException e) {
            SEL.error("Unable to process parameters: {}", (Object)e.getMessage());
        }
        return parameters;
    }

    protected void combineParameters(String queryString, Map parameters) {
        try {
            byte[] data = queryString.getBytes("8859_1");
            Util.parseQueryString(data, "8859_1", parameters, true, -1);
        }
        catch (UnsupportedEncodingException e) {
            SEL.error("Unable to process query string '{}': ISO-8859-1 unsupported", (Object)queryString);
        }
    }

    public String getParameter(String name) {
        String[] values;
        if (this.trace) {
            this.logger.trace("getParameter({})", (Object)name);
        }
        if (this.parameters == null) {
            String encoding = this.getCharacterEncoding();
            if (encoding == null) {
                encoding = "8859_1";
            }
            this.parameters = this.processParameters(encoding);
        }
        if ((values = this.getParameterValues(name)) != null) {
            return values[0];
        }
        return null;
    }

    public Map getParameterMap() {
        if (this.trace) {
            this.logger.trace("getParameterMap");
        }
        if (this.parameters == null) {
            String encoding = this.getCharacterEncoding();
            if (encoding == null) {
                encoding = "8859_1";
            }
            this.parameters = this.processParameters(encoding);
        }
        return Collections.unmodifiableMap(this.parameters);
    }

    public Enumeration getParameterNames() {
        if (this.trace) {
            this.logger.trace("getParameterNames");
        }
        if (this.parameters == null) {
            String encoding = this.getCharacterEncoding();
            if (encoding == null) {
                encoding = "8859_1";
            }
            this.parameters = this.processParameters(encoding);
        }
        return Collections.enumeration(this.parameters.keySet());
    }

    public String[] getParameterValues(String name) {
        if (this.trace) {
            this.logger.trace("getParameterValues({})", (Object)name);
        }
        if (this.parameters == null) {
            String encoding = this.getCharacterEncoding();
            if (encoding == null) {
                encoding = "8859_1";
            }
            this.parameters = this.processParameters(encoding);
        }
        return (String[])this.parameters.get(name);
    }

    public String getProtocol() {
        if (this.trace) {
            this.logger.trace("getProtocol");
        }
        return this.handler.getProtocol();
    }

    public String getScheme() {
        if (this.trace) {
            this.logger.trace("getScheme");
        }
        return this.handler.getScheme();
    }

    public String getServerName() {
        if (this.trace) {
            this.logger.trace("getServerName");
        }
        if (this.serverName == null) {
            this.serverName = this.handler.getServerName();
        }
        return this.serverName;
    }

    public int getServerPort() {
        if (this.trace) {
            this.logger.trace("getServerPort");
        }
        if (this.serverPort == -1) {
            this.serverPort = this.handler.getServerPort();
        }
        return this.serverPort;
    }

    public BufferedReader getReader() throws UnsupportedEncodingException, IllegalStateException, IOException {
        if (this.trace) {
            this.logger.trace("getReader");
        }
        if (this.reader == null) {
            String encoding;
            if (this.servletIn != null) {
                throw new IllegalStateException("getInputStream() already called");
            }
            if (this.filterIn == null) {
                long contentLength;
                this.filterIn = this.hasChunkedBody() ? new ChunkedBodyInputStream(this, this.in) : ((contentLength = this.getContentLengthLong()) == -1L ? EMPTY_INPUT_STREAM : new BoundedInputStream(this, this.in, contentLength));
            }
            if ((encoding = this.getCharacterEncoding()) == null) {
                encoding = "8859_1";
            }
            this.reader = new BufferedReader(new InputStreamReader(this.filterIn, encoding));
        }
        return this.reader;
    }

    public InetAddress getRemoteInetAddress() {
        return this.handler.getRemoteAddr();
    }

    public String getRemoteAddr() {
        if (this.trace) {
            this.logger.trace("getRemoteAddr");
        }
        return this.handler.getRemoteAddr().getHostAddress();
    }

    public String getRemoteHost() {
        if (this.trace) {
            this.logger.trace("getRemoteHost");
        }
        return this.handler.getRemoteHost();
    }

    public void setAttribute(String name, Object value) {
        this.setAttribute(name, value, true);
    }

    void setAttribute(String name, Object value, boolean notify) {
        if (value == null) {
            this.removeAttribute(name, notify);
            return;
        }
        Object old = this.attributes.put(name, value);
        if (notify) {
            if (old != null) {
                this.application.requestAttributeReplaced(new ServletRequestAttributeEvent(this.application, this, name, old));
            } else {
                this.application.requestAttributeAdded(new ServletRequestAttributeEvent(this.application, this, name, value));
            }
        }
    }

    public void removeAttribute(String name) {
        this.removeAttribute(name, true);
    }

    void removeAttribute(String name, boolean notify) {
        Object o = this.attributes.remove(name);
        if (o != null && notify) {
            this.application.requestAttributeRemoved(new ServletRequestAttributeEvent(this.application, this, name, o));
        }
    }

    public Locale getLocale() {
        if (this.locale == null) {
            if (this.languageTags == null) {
                this.languageTags = this.getLanguageTags();
            }
            this.locale = this.languageTags.length == 0 ? Locale.getDefault() : new Locale(this.languageTags[0].primary, this.languageTags[0].subtag);
        }
        return this.locale;
    }

    public Enumeration getLocales() {
        if (this.locales == null) {
            if (this.languageTags == null) {
                this.languageTags = this.getLanguageTags();
            }
            if (this.languageTags.length == 0) {
                this.locales = new Locale[]{Locale.getDefault()};
            } else {
                this.locales = new Locale[this.languageTags.length];
                for (int i = 0; i < this.languageTags.length; ++i) {
                    this.locales[i] = new Locale(this.languageTags[i].primary, this.languageTags[i].subtag);
                }
            }
        }
        return Collections.enumeration(Arrays.asList(this.locales));
    }

    private Util.LanguageTag[] getLanguageTags() {
        String s = this.getHeader("Accept-Language");
        if (s != null) {
            try {
                return Util.parseAcceptLanguage(s);
            }
            catch (IllegalArgumentException e) {
                this.logger.warn("Unable to parse accept language header: {}", (Object)e.getMessage());
            }
        }
        return new Util.LanguageTag[0];
    }

    public boolean isSecure() {
        return this.isSecureRequest;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        if (this.trace) {
            this.logger.trace("getRequestDispatcher({})", (Object)path);
        }
        path = Text.fullPath(this.urlPath.getServletPath(), path);
        return this.application.createRequestDispatcher(path);
    }

    public String getLocalAddr() {
        return this.handler.getLocalAddr().getHostAddress();
    }

    public String getLocalName() {
        return this.handler.getLocalHost();
    }

    public int getLocalPort() {
        return this.handler.getLocalPort();
    }

    public int getRemotePort() {
        return this.handler.getRemotePort();
    }

    public String getRealPath(String path) {
        if (this.trace) {
            this.logger.trace("getRealPath({})", (Object)path);
        }
        return this.application.getRealPath(path);
    }

    void setReadTimeout(int seconds) throws IOException {
        this.handler.setReadTimeout(seconds);
    }

    boolean keepAliveDisabled() {
        return this.keepAliveDisabled;
    }

    void disableKeepAlive() {
        this.keepAliveDisabled = true;
    }

    private boolean hasChunkedBody() {
        String tEncoding = this.getHeader("Transfer-Encoding");
        return tEncoding != null && tEncoding.toLowerCase().indexOf("chunked") >= 0;
    }
}

