/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.servletengine;

import com.day.j2ee.servletengine.Constants;
import java.io.UnsupportedEncodingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RequestURL
implements Constants {
    private static final Logger SEL = LoggerFactory.getLogger((String)"servletengine");
    private static final String JSESSIONID_PREFIX = ";jsessionid=";
    private String pathParameters;
    private String sessionId;
    private String queryString;
    private String extension;
    private String requestURI;
    private String decodedRequestURI;

    public RequestURL(String s) {
        this.decompose(s);
    }

    private void decompose(String s) {
        int extIndex;
        int pathParameterIndex = s.indexOf(59);
        int queryIndex = s.indexOf(63);
        int sessionIdIndex = -1;
        if (pathParameterIndex == -1) {
            pathParameterIndex = s.length();
        }
        if (queryIndex == -1) {
            queryIndex = s.length();
        }
        if (pathParameterIndex < queryIndex) {
            this.pathParameters = RequestURL.decode(s.substring(pathParameterIndex, queryIndex));
            sessionIdIndex = this.pathParameters.indexOf(JSESSIONID_PREFIX);
            if (sessionIdIndex != -1) {
                this.sessionId = this.pathParameters.substring(sessionIdIndex + JSESSIONID_PREFIX.length());
                this.pathParameters = this.pathParameters.substring(0, sessionIdIndex);
            }
        }
        if (queryIndex < s.length()) {
            this.queryString = s.substring(queryIndex + 1);
        }
        this.requestURI = s.substring(0, sessionIdIndex == -1 ? queryIndex : pathParameterIndex + sessionIdIndex);
        String paramLess = s.substring(0, Math.min(pathParameterIndex, queryIndex));
        int nameIndex = paramLess.lastIndexOf(47);
        if (nameIndex != -1 && (extIndex = paramLess.substring(nameIndex).lastIndexOf(46)) != -1) {
            this.extension = RequestURL.decode(paramLess.substring(nameIndex + extIndex + 1));
        }
        this.decodedRequestURI = RequestURL.decode(paramLess);
    }

    private static String decode(String s) {
        boolean needToChange = false;
        int numChars = s.length();
        StringBuffer sb = new StringBuffer(numChars > 500 ? numChars / 2 : numChars);
        int i = 0;
        byte[] bytes = null;
        block6: while (i < numChars) {
            char c = s.charAt(i);
            switch (c) {
                case '%': {
                    try {
                        if (bytes == null) {
                            bytes = new byte[(numChars - i) / 3];
                        }
                        int pos = 0;
                        while (i + 2 < numChars && c == '%') {
                            bytes[pos++] = (byte)Integer.parseInt(s.substring(i + 1, i + 3), 16);
                            if ((i += 3) >= numChars) continue;
                            c = s.charAt(i);
                        }
                        if (i < numChars && c == '%') {
                            SEL.warn("Unable to decode: '" + s + "' because of: " + "Incomplete trailing escape (%) pattern");
                            return s;
                        }
                        sb.append(new String(bytes, 0, pos, "UTF-8"));
                    }
                    catch (NumberFormatException e) {
                        SEL.warn("Unable to decode: '" + s + "' because of: " + "Illegal hex characters in escape (%) pattern - " + e.getMessage());
                        return s;
                    }
                    catch (UnsupportedEncodingException e) {
                        SEL.warn("UTF-8 unsupported, unable to decode: '" + s + "'");
                        return s;
                    }
                    needToChange = true;
                    continue block6;
                }
            }
            sb.append(c);
            ++i;
        }
        return needToChange ? sb.toString() : s;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public String getDecodedRequestURI() {
        return this.decodedRequestURI;
    }

    public String toString() {
        StringBuffer requestURL = new StringBuffer();
        requestURL.append(this.requestURI);
        if (this.pathParameters != null) {
            requestURL.append(this.pathParameters);
        }
        if (this.sessionId != null) {
            requestURL.append(JSESSIONID_PREFIX);
            requestURL.append(this.sessionId);
        }
        if (this.queryString != null) {
            requestURL.append('?');
            requestURL.append(this.queryString);
        }
        return requestURL.toString();
    }
}

