/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.servletengine;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.Date;

class ResourceURLConnection
extends URLConnection {
    protected static final String CONTENT_LENGTH = "content-length";
    protected static final String CONTENT_TYPE = "content-type";
    protected static final String LAST_MODIFIED = "last-modified";
    protected final File file;

    public ResourceURLConnection(URL u) {
        super(u);
        try {
            String path = URLDecoder.decode(this.url.getFile(), "UTF-8");
            this.file = new File(path.replace('/', File.separatorChar));
        }
        catch (UnsupportedEncodingException e) {
            throw new InternalError("UTF-8 not supported");
        }
    }

    public void connect() throws IOException {
        if (!this.connected) {
            this.connected = true;
        }
    }

    public int getContentLength() {
        return (int)this.file.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getContentType() {
        String contentType = super.getContentType();
        if (contentType != null) return contentType;
        InputStream is = null;
        is = this.getInputStream();
        contentType = ResourceURLConnection.guessContentTypeFromStream(is);
        Object var5_3 = null;
        if (is == null) return contentType;
        try {
            is.close();
            return contentType;
        }
        catch (IOException e) {}
        return contentType;
        {
            catch (IOException iOException) {
                Object var5_4 = null;
                if (is == null) return contentType;
                try {
                    is.close();
                    return contentType;
                }
                catch (IOException e) {}
                return contentType;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (is == null) throw throwable;
            try {
                is.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
    }

    public String getHeaderField(String name) {
        if (CONTENT_LENGTH.equals(name)) {
            return String.valueOf(this.file.length());
        }
        if (CONTENT_TYPE.equals(name)) {
            return URLConnection.getFileNameMap().getContentTypeFor(this.file.getPath());
        }
        if (LAST_MODIFIED.equals(name)) {
            return new Date(this.file.lastModified()).toString();
        }
        return super.getHeaderField(name);
    }

    public String getHeaderFieldKey(int n) {
        switch (n) {
            case 0: {
                return CONTENT_LENGTH;
            }
            case 1: {
                return CONTENT_TYPE;
            }
            case 2: {
                return LAST_MODIFIED;
            }
        }
        return super.getHeaderFieldKey(n);
    }

    public String getHeaderField(int n) {
        String key = this.getHeaderFieldKey(n);
        if (key != null) {
            return this.getHeaderField(key);
        }
        return super.getHeaderField(n);
    }

    public InputStream getInputStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.file));
    }

    public long getLastModified() {
        return this.file.lastModified();
    }
}

