/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.servletengine;

import com.day.j2ee.servletengine.Constants;
import com.day.j2ee.servletengine.ServletEngine;
import com.day.j2ee.servletengine.ServletHandler;
import com.day.j2ee.servletengine.ServletOutputStreamImpl;
import com.day.j2ee.servletengine.ServletPrintWriter;
import com.day.j2ee.servletengine.Util;
import com.day.j2ee.servletengine.WebApplication;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseImpl
implements HttpServletResponse,
Constants {
    private static final Logger SEL = LoggerFactory.getLogger((String)"servletengine");
    private static final int BUFFER_SIZE = 32768;
    private static final String DEFAULT_ENC = "ISO-8859-1";
    private static final byte[] CR_LF = "\r\n".getBytes();
    private static final byte[] LAST_CHUNK = "0\r\n\r\n".getBytes();
    private boolean committed;
    private boolean suspended;
    private static ResourceBundle bundle;
    private byte[] buffer = new byte[32768];
    private int bufferCount;
    private final ServletHandler handler;
    private final Map headers = new HashMap();
    private final List cookies = new ArrayList();
    private OutputStream out;
    private ServletOutputStreamImpl stream;
    private PrintWriter writer;
    private int status = 200;
    private String message;
    private int contentLength = -1;
    private String contentType = null;
    private String characterEncoding;
    private boolean chunked;
    private int includeLevel;
    private boolean keepConnection;
    private boolean connectionChecked;
    private boolean closeConnection;
    private String defaultServerName;
    private String serverName;
    private final CharArrayWriter responseHeaders = new CharArrayWriter(32768);
    private Logger logger;
    private boolean debug;
    private boolean trace;
    private Throwable caller;
    private int written;
    private int transmitted;
    private boolean error;

    public ResponseImpl(ServletHandler handler) {
        this.handler = handler;
        this.defaultServerName = ServletEngine.getVersion().getServerHeader();
    }

    public void attach(OutputStream out) {
        this.out = out;
    }

    public void finish() {
        if (this.status < 400 && this.stream == null && this.contentLength == -1 && this.status >= 200) {
            this.setContentLength(0);
        }
        if (!this.isCommitted() && this.stream == null && this.status >= 400 && this.written == 0) {
            this.suspended = false;
            try {
                this.setContentType("text/html");
                PrintWriter writer = this.getWriter();
                writer.println("<html><head><title>");
                writer.println(String.valueOf(this.status));
                writer.println(" ");
                writer.println(ResponseImpl.reasonPhrase(this.status));
                writer.println("</title></head><body><h1>");
                writer.println(ResponseImpl.reasonPhrase(this.status));
                writer.println("</h1>");
                if (this.message != null) {
                    writer.println("<p>");
                    writer.println(this.message);
                    writer.println("</p>");
                }
                writer.println("</body></html>");
            }
            catch (IOException e) {
                SEL.debug("I/O error on sending a default error message: {}", (Object)e.getMessage());
            }
            catch (Throwable e) {
                SEL.warn("Unexpected error on sending a default error message: {}", (Object)e.getMessage());
            }
        }
        if (this.stream == null) {
            this.getOutputStream();
        }
        if (this.writer != null) {
            this.writer.close();
        } else {
            try {
                this.stream.close();
            }
            catch (IOException e) {
                SEL.debug("I/O error on closing: {}", (Object)e.getMessage());
            }
        }
        try {
            this.flushBuffer();
        }
        catch (IOException e) {
            SEL.debug("I/O error on flushing: {}", (Object)e.getMessage());
        }
        try {
            if (this.chunked) {
                this.internalWrite(null, 0, 0);
            }
        }
        catch (IOException e) {
            SEL.info("Unable to send back last chunk: {}", (Object)e.getMessage());
        }
    }

    public void recycle() {
        this.headers.clear();
        this.cookies.clear();
        this.contentType = null;
        this.characterEncoding = null;
        this.includeLevel = 0;
        this.contentLength = -1;
        this.bufferCount = 0;
        this.written = 0;
        this.transmitted = 0;
        this.committed = false;
        this.suspended = false;
        this.connectionChecked = false;
        this.closeConnection = false;
        this.chunked = false;
        this.error = false;
        this.serverName = this.defaultServerName;
        this.responseHeaders.reset();
        this.status = 200;
        this.message = null;
        this.stream = null;
        this.writer = null;
    }

    public void setSuspended(boolean suspended) {
        this.suspended = suspended;
    }

    public boolean isSuspended() {
        return this.suspended;
    }

    public void setApplication(WebApplication application) {
        this.logger = application.getLogger();
        this.debug = application.getLogger().isDebugEnabled();
        this.trace = application.getLogger().isTraceEnabled();
    }

    protected void beforeInclude() {
        ++this.includeLevel;
    }

    protected void afterInclude() {
        --this.includeLevel;
    }

    public void addCookie(Cookie cookie) {
        if (this.trace) {
            this.logger.trace("addCookie({})", (Object)cookie);
        }
        if (this.isIncluded()) {
            return;
        }
        this.cookies.add(cookie);
    }

    public boolean containsHeader(String name) {
        if (this.trace) {
            this.logger.trace("containsHeader({})", (Object)name);
        }
        if (this.headers != null) {
            return this.headers.containsKey(name);
        }
        return false;
    }

    public String encodeURL(String url) {
        if (this.trace) {
            this.logger.trace("encodeURL({})", (Object)url);
        }
        return this.handler.encodeURL(url);
    }

    public String encodeRedirectURL(String url) {
        if (this.trace) {
            this.logger.trace("encodeRedirectURL({})", (Object)url);
        }
        return this.encodeURL(url);
    }

    public String encodeUrl(String url) {
        if (this.trace) {
            this.logger.trace("encodeUrl({})", (Object)url);
        }
        return this.encodeURL(url);
    }

    public String encodeRedirectUrl(String url) {
        if (this.trace) {
            this.logger.trace("encodeRedirectUrl({})", (Object)url);
        }
        return this.encodeRedirectURL(url);
    }

    public void sendError(int status) throws IllegalStateException, IOException {
        if (this.trace) {
            this.logger.trace("sendError({})", (Object)String.valueOf(status));
        }
        this.sendError(status, null);
    }

    public void sendError(int status, String message) throws IllegalStateException, IOException {
        if (this.trace) {
            this.logger.trace("sendError({},{})", (Object)String.valueOf(status), (Object)message);
        }
        if (this.committed) {
            throw new IllegalStateException("response already committed");
        }
        if (this.isIncluded()) {
            return;
        }
        this.setError();
        this.status = status;
        this.message = message;
        this.resetBuffer();
        this.setSuspended(true);
    }

    public void setError() {
        this.error = true;
    }

    public boolean isError() {
        return this.error;
    }

    public void sendRedirect(String location) throws IOException, IllegalStateException {
        String redirectLocation;
        URL redirectURL;
        if (this.trace) {
            this.logger.trace("sendRedirect({})", (Object)location);
        }
        if (this.committed) {
            throw new IllegalStateException("response already committed");
        }
        if (this.isIncluded()) {
            return;
        }
        try {
            URL contextURL = new URL(this.handler.getRequestURL().toString());
            redirectURL = new URL(contextURL, location);
        }
        catch (MalformedURLException e) {
            String msg = "Malformed redirect URL '" + location + "' from request: " + this.handler.getRequestURL().toString();
            throw new IllegalStateException(msg);
        }
        if (location.toLowerCase().startsWith("http")) {
            redirectLocation = redirectURL.toExternalForm();
        } else {
            redirectLocation = redirectURL.getFile();
            if (redirectURL.getRef() != null) {
                redirectLocation = redirectLocation + "#" + redirectURL.getRef();
            }
        }
        this.resetBuffer();
        this.setStatus(302);
        this.setHeader("Location", redirectLocation);
        this.setSuspended(true);
    }

    public void setDateHeader(String name, long date) {
        if (this.trace) {
            this.logger.trace("setDateHeader({},{})", (Object)name, (Object)String.valueOf(date));
        }
        this.setHeader(name, Util.dateToString(new Date(date)));
    }

    public void addDateHeader(String name, long date) {
        if (this.trace) {
            this.logger.trace("addDateHeader({},{})", (Object)name, (Object)String.valueOf(date));
        }
        this.addHeader(name, Util.dateToString(new Date(date)));
    }

    public void setHeader(String name, String value) {
        if (this.trace) {
            this.logger.trace("setHeader({},{})", (Object)name, (Object)value);
        }
        this.setHeader(name, value, false);
    }

    public void addHeader(String name, String value) {
        if (this.trace) {
            this.logger.trace("addHeader({},{})", (Object)name, (Object)value);
        }
        this.setHeader(name, value, true);
    }

    public void setIntHeader(String name, int value) {
        if (this.trace) {
            this.logger.trace("setIntHeader({},{})", (Object)name, (Object)String.valueOf(value));
        }
        this.setHeader(name, String.valueOf(value));
    }

    public void addIntHeader(String name, int value) {
        if (this.trace) {
            this.logger.trace("addIntHeader({},{})", (Object)name, (Object)String.valueOf(value));
        }
        this.addHeader(name, String.valueOf(value));
    }

    protected void setHeader(String name, String value, boolean add) {
        if (this.isIncluded()) {
            return;
        }
        String nameCaseless = name.toLowerCase();
        if (nameCaseless.equals("content-length")) {
            try {
                this.setContentLength(Integer.parseInt(value));
            }
            catch (RuntimeException e) {
                SEL.warn("Bad content length specified: {}", (Object)value);
            }
        } else if (nameCaseless.equals("content-type")) {
            this.setContentType(value);
        } else if (nameCaseless.equals("connection")) {
            this.closeConnection = value.equalsIgnoreCase("close");
        } else if (nameCaseless.equals("server")) {
            this.serverName = value;
        } else if (nameCaseless.equals("transfer-encoding")) {
            if (value.equalsIgnoreCase("chunked")) {
                // empty if block
            }
        } else {
            ArrayList<String> list = (ArrayList<String>)this.headers.get(name);
            if (list == null) {
                list = new ArrayList<String>();
                this.headers.put(name, list);
            } else if (!add) {
                list.clear();
            }
            list.add(value);
        }
    }

    public String getHeader(String name) {
        String nameCaseless = name.toLowerCase();
        if (nameCaseless.equals("content-length")) {
            if (this.contentLength != -1) {
                return String.valueOf(this.contentLength);
            }
        } else {
            if (nameCaseless.equals("content-type")) {
                return this.getContentType();
            }
            if (nameCaseless.equals("connection")) {
                return this.isKeepAlive() ? "Keep-Alive" : "Close";
            }
            if (nameCaseless.equals("server")) {
                return this.serverName;
            }
            List values = (List)this.headers.get(name);
            if (values != null) {
                return (String)values.get(0);
            }
        }
        return null;
    }

    public void setStatus(int sc) {
        if (this.trace) {
            this.logger.trace("setStatus({})", (Object)String.valueOf(sc));
        }
        if (this.isIncluded()) {
            return;
        }
        this.status = sc;
    }

    protected int getStatus() {
        return this.status;
    }

    protected String getMessage() {
        return this.message;
    }

    public void setStatus(int sc, String sm) {
        if (this.trace) {
            this.logger.trace("setStatus({},{})", (Object)String.valueOf(sc), (Object)sm);
        }
        this.setStatus(sc);
    }

    public String getCharacterEncoding() {
        if (this.trace) {
            this.logger.trace("getCharacterEncoding()");
        }
        return this.characterEncoding == null ? DEFAULT_ENC : this.characterEncoding;
    }

    public ServletOutputStream getOutputStream() throws IllegalStateException {
        if (this.trace) {
            this.logger.trace("getOutputStream()");
        }
        if (this.writer != null) {
            if (this.debug) {
                this.logger.debug("Writer already obtained by: ", this.caller);
            }
            throw new IllegalStateException("writer already obtained");
        }
        if (this.debug) {
            this.caller = new Exception("Stack trace");
        }
        if (this.stream == null) {
            this.stream = new ServletOutputStreamImpl(this, true);
        }
        return this.stream;
    }

    public PrintWriter getWriter() throws UnsupportedEncodingException, IllegalStateException {
        if (this.trace) {
            this.logger.trace("getWriter()");
        }
        if (this.writer != null) {
            return this.writer;
        }
        if (this.stream != null) {
            if (this.debug) {
                this.logger.debug("OutputStream already obtained by: ", this.caller);
            }
            throw new IllegalStateException("output stream already obtained");
        }
        if (this.debug) {
            this.caller = new Exception("Stack trace");
        }
        ServletOutputStreamImpl stream = new ServletOutputStreamImpl(this, false);
        OutputStreamWriter osr = new OutputStreamWriter((OutputStream)stream, this.getCharacterEncoding());
        this.writer = new ServletPrintWriter(this, osr, stream);
        this.stream = stream;
        return this.writer;
    }

    public void setContentLength(int len) {
        if (this.trace) {
            this.logger.trace("setContentLength({})", (Object)String.valueOf(len));
        }
        if (this.committed) {
            return;
        }
        if (this.isIncluded()) {
            return;
        }
        this.contentLength = len;
    }

    protected int getContentLength() {
        return this.contentLength;
    }

    public void setContentType(String type) {
        int charsetStart;
        int idx;
        if (this.trace) {
            this.logger.trace("setContentType({})", (Object)type);
        }
        if (this.committed) {
            return;
        }
        if (this.isIncluded()) {
            return;
        }
        if (type != null && (idx = type.indexOf(59)) >= 0 && (charsetStart = type.indexOf("charset=", idx)) != -1) {
            int charsetEnd = type.indexOf(59, charsetStart + 1);
            if (charsetEnd == -1) {
                charsetEnd = type.length();
            }
            this.characterEncoding = type.substring(charsetStart + "charset=".length(), charsetEnd);
            type = type.substring(0, idx) + type.substring(charsetEnd);
        }
        this.contentType = type;
    }

    protected boolean isKeepAlive() {
        if (!this.connectionChecked) {
            this.keepConnection = !(this.status >= 400 && this.status != 401 || this.contentLength == -1 && !this.chunked || this.closeConnection || !this.handler.keepConnection());
            this.connectionChecked = true;
        }
        return this.keepConnection;
    }

    public void setBufferSize(int size) {
        if (this.trace) {
            this.logger.trace("setBufferSize({})", (Object)String.valueOf(size));
        }
        if (this.isCommitted() || this.bufferCount > 0) {
            throw new IllegalStateException("content already written");
        }
        this.buffer = new byte[size];
    }

    public int getBufferSize() {
        return this.buffer.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushBuffer() throws IOException {
        if (this.trace) {
            this.logger.trace("flushBuffer()");
        }
        if (!this.committed) {
            this.sendHeaders();
        }
        if (this.bufferCount > 0) {
            try {
                this.internalWrite(this.buffer, 0, this.bufferCount);
                this.transmitted += this.bufferCount;
            }
            finally {
                this.bufferCount = 0;
            }
        }
    }

    public boolean isCommitted() {
        if (this.trace) {
            this.logger.trace("isCommitted()");
        }
        return this.committed;
    }

    public void reset() {
        if (this.trace) {
            this.logger.trace("reset()");
        }
        if (this.committed) {
            throw new IllegalStateException("response already committed");
        }
        if (this.isIncluded()) {
            return;
        }
        this.bufferCount = 0;
        this.contentLength = -1;
        this.contentType = null;
        this.cookies.clear();
        this.headers.clear();
        this.message = null;
        this.status = 200;
    }

    public void resetBuffer() throws IllegalStateException {
        if (this.trace) {
            this.logger.trace("resetBuffer()");
        }
        if (this.committed) {
            throw new IllegalStateException("response already committed");
        }
        if (!this.isIncluded()) {
            this.bufferCount = 0;
            this.written = 0;
        }
    }

    public void setLocale(Locale loc) {
        if (this.trace) {
            this.logger.trace("setLocale({})", (Object)loc);
        }
        if (!this.isIncluded()) {
            // empty if block
        }
    }

    public Locale getLocale() {
        if (this.trace) {
            this.logger.trace("getLocale()");
        }
        return null;
    }

    public String getContentType() {
        if (this.contentType != null && this.characterEncoding != null) {
            StringBuffer buf = new StringBuffer(this.contentType);
            buf.append(";charset=");
            buf.append(this.characterEncoding);
            return buf.toString();
        }
        return this.contentType;
    }

    String getRawContentType() {
        return this.contentType;
    }

    public void setCharacterEncoding(String encoding) {
        if (this.committed) {
            return;
        }
        if (this.isIncluded()) {
            return;
        }
        this.characterEncoding = encoding;
    }

    protected static final String reasonPhrase(int status) {
        switch (status) {
            case 200: {
                return "OK";
            }
            case 304: {
                return "Not Modified";
            }
            case 204: {
                return "No Content";
            }
            case 401: {
                return "Unauthorized";
            }
            case 404: {
                return "Not Found";
            }
            case 405: {
                return "Method Not Allowed";
            }
            case 500: {
                return "Internal Server Error";
            }
        }
        if (bundle != null) {
            try {
                return bundle.getString(String.valueOf(status));
            }
            catch (MissingResourceException missingResourceException) {
                // empty catch block
            }
        }
        return "Code " + String.valueOf(status);
    }

    protected void sendHeaders() throws IOException {
        if (!this.committed) {
            String value;
            if (this.contentLength == -1 && this.stream != null) {
                if (this.stream.isClosed()) {
                    this.contentLength = this.written;
                } else if (this.handler.isHttp11()) {
                    this.chunked = true;
                }
            }
            this.responseHeaders.write("HTTP/1.1 ");
            this.responseHeaders.write(String.valueOf(this.status));
            this.responseHeaders.write(" ");
            this.responseHeaders.write(ResponseImpl.reasonPhrase(this.status));
            this.responseHeaders.write("\r\nConnection: ");
            this.responseHeaders.write(this.isKeepAlive() ? "Keep-Alive" : "Close");
            this.responseHeaders.write("\r\nServer: ");
            this.responseHeaders.write(this.serverName);
            this.responseHeaders.write("\r\n");
            String contentType = this.getContentType();
            if (contentType != null) {
                this.responseHeaders.write("Content-Type: ");
                this.responseHeaders.write(ResponseImpl.replaceControlCharacters(contentType));
                this.responseHeaders.write("\r\n");
            }
            if (this.contentLength != -1) {
                this.responseHeaders.write("Content-Length: ");
                this.responseHeaders.write(String.valueOf(this.contentLength));
                this.responseHeaders.write("\r\n");
            }
            if (!this.containsHeader("Date")) {
                this.responseHeaders.write("Date: ");
                this.responseHeaders.write(Util.dateToString(new Date()));
                this.responseHeaders.write("\r\n");
            }
            if (this.chunked) {
                this.responseHeaders.write("Transfer-Encoding: chunked\r\n");
            }
            Iterator headers = this.headers.keySet().iterator();
            while (headers.hasNext()) {
                String name = (String)headers.next();
                List values = (List)this.headers.get(name);
                for (int i = 0; i < values.size(); ++i) {
                    value = (String)values.get(i);
                    if (value == null) continue;
                    this.responseHeaders.write(name);
                    this.responseHeaders.write(": ");
                    this.responseHeaders.write(ResponseImpl.replaceControlCharacters(value));
                    this.responseHeaders.write("\r\n");
                }
            }
            Iterator cookies = this.cookies.iterator();
            while (cookies.hasNext()) {
                Cookie cookie = (Cookie)cookies.next();
                String name = Util.getCookieHeaderName(cookie);
                value = Util.getCookieHeaderValue(cookie);
                this.responseHeaders.write(name);
                this.responseHeaders.write(": ");
                this.responseHeaders.write(ResponseImpl.replaceControlCharacters(value));
                if (Util.cookieIsHttpOnly(cookie)) {
                    this.responseHeaders.write("; ");
                    this.responseHeaders.write("HttpOnly");
                }
                this.responseHeaders.write("\r\n");
            }
            this.responseHeaders.write("\r\n");
            byte[] headerData = this.responseHeaders.toString().getBytes("8859_1");
            this.out.write(headerData);
            this.out.flush();
            this.transmitted += headerData.length;
            this.committed = true;
        }
    }

    protected void write(int b) throws IOException {
        if (this.bufferCount >= this.buffer.length) {
            this.flushBuffer();
        }
        if (this.buffer.length == 0) {
            this.internalWrite(b);
        } else {
            this.buffer[this.bufferCount++] = (byte)b;
        }
        ++this.written;
    }

    protected void write(byte[] b, int off, int len) throws IOException {
        if (len >= this.buffer.length) {
            this.flushBuffer();
            this.internalWrite(b, off, len);
            this.transmitted += len;
            this.written += len;
            return;
        }
        if (len > this.buffer.length - this.bufferCount) {
            this.flushBuffer();
        }
        System.arraycopy(b, off, this.buffer, this.bufferCount, len);
        this.bufferCount += len;
        this.written += len;
    }

    private void internalWrite(int b) throws IOException {
        if (this.handler.isHeadRequest()) {
            return;
        }
        if (!this.chunked) {
            this.out.write(b);
        } else {
            byte[] hexLen = "0001".getBytes();
            this.out.write(hexLen, 0, hexLen.length);
            this.out.write(CR_LF, 0, CR_LF.length);
            this.out.write(b);
            this.out.write(CR_LF, 0, CR_LF.length);
        }
    }

    private void internalWrite(byte[] b, int off, int len) throws IOException {
        if (this.handler.isHeadRequest()) {
            return;
        }
        if (!this.chunked) {
            this.out.write(b, off, len);
        } else if (len == 0) {
            this.out.write(LAST_CHUNK, 0, LAST_CHUNK.length);
        } else {
            byte[] hexLen = Integer.toHexString(len).getBytes();
            this.out.write(hexLen, 0, hexLen.length);
            this.out.write(CR_LF, 0, CR_LF.length);
            this.out.write(b, off, len);
            this.out.write(CR_LF, 0, CR_LF.length);
        }
    }

    protected final boolean isIncluded() {
        return this.includeLevel > 0;
    }

    public String toString() {
        StringBuffer b = new StringBuffer(super.toString());
        b.append("(buf.length=");
        b.append(String.valueOf(this.buffer.length));
        b.append(",count=");
        b.append(String.valueOf(this.bufferCount));
        b.append(",written=");
        b.append(String.valueOf(this.written));
        b.append(",transmitted=");
        b.append(String.valueOf(this.transmitted));
        b.append(",stream=");
        b.append(String.valueOf(this.stream != null));
        b.append(",writer=");
        b.append(String.valueOf(this.writer != null));
        b.append(",status=");
        b.append(String.valueOf(this.status));
        b.append(",contentLength=");
        b.append(String.valueOf(this.contentLength));
        b.append(")");
        return b.toString();
    }

    private static String replaceControlCharacters(String s) {
        char[] input = s.toCharArray();
        char[] output = new char[input.length];
        for (int i = 0; i < input.length; ++i) {
            int c = input[i];
            if (c <= 31 && c != 9) {
                c = 32;
            } else if (c == 127) {
                c = 32;
            }
            output[i] = c;
        }
        return new String(output);
    }

    static {
        try {
            bundle = ResourceBundle.getBundle("com.day.j2ee.servletengine.Resource");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }
}

