/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.servletengine;

import com.day.j2ee.servletengine.Constants;
import com.day.j2ee.servletengine.ResponseImpl;
import java.io.IOException;
import javax.servlet.ServletOutputStream;

class ServletOutputStreamImpl
extends ServletOutputStream
implements Constants {
    private final ResponseImpl response;
    private boolean closed;
    private boolean commitOnFlush;

    public ServletOutputStreamImpl(ResponseImpl response, boolean commitOnFlush) {
        this.response = response;
        this.commitOnFlush = commitOnFlush;
    }

    public void close() throws IOException {
        if (this.response.isIncluded()) {
            return;
        }
        if (!this.closed) {
            this.closed = true;
        }
    }

    boolean isClosed() {
        return this.closed;
    }

    public void write(int b) throws IOException {
        if (this.response.isSuspended() || this.closed) {
            return;
        }
        this.response.write(b);
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.response.isSuspended() || this.closed) {
            return;
        }
        this.response.write(b, off, len);
    }

    public void flush() throws IOException {
        if (this.response.isSuspended() || this.closed) {
            return;
        }
        if (this.commitOnFlush) {
            this.response.flushBuffer();
        }
    }

    public void setCommitOnFlush(boolean commitOnFlush) {
        this.commitOnFlush = commitOnFlush;
    }
}

