/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.servletengine;

import com.day.j2ee.config.Param;
import com.day.j2ee.servletengine.ServletWrapper;
import com.day.j2ee.servletengine.WebApplication;
import com.day.util.IteratorEnumeration;
import java.io.IOException;
import java.util.Enumeration;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.slf4j.Logger;

class ServletRuntimeEnvironment
implements ServletConfig,
ServletWrapper {
    protected static final String JSP_FILE = "org.apache.catalina.jsp_file";
    protected static final String SERVLET_CONFIG = "org.apache.catalina.servlet_config";
    protected final com.day.j2ee.config.Servlet config;
    protected Servlet servlet;
    protected final WebApplication application;
    protected final Logger logger;
    protected int state;
    protected static final int NONE = 0;
    protected static final int INITIALIZED = 1;
    protected static final int DESTROYED = 2;
    protected static final int UNAVAILABLE = 3;
    private boolean isJspServlet;

    public ServletRuntimeEnvironment(WebApplication application, com.day.j2ee.config.Servlet config) {
        this(application, config, null);
    }

    public ServletRuntimeEnvironment(WebApplication application, com.day.j2ee.config.Servlet config, Servlet servlet) {
        this.application = application;
        this.logger = application.getLogger();
        this.config = config;
        this.servlet = servlet;
    }

    public synchronized void init() throws ServletException {
        if (this.state == 0) {
            this.state = 1;
            this.logger.debug("Start servlet '{}'", (Object)this.getServletName());
            this.doInit();
        }
    }

    protected void doInit() throws ServletException {
        ClassLoader loader = this.application.getLoader();
        Object o = null;
        try {
            o = this.application.enter();
            if (this.servlet == null) {
                Class<?> servletClass = loader.loadClass(this.config.getServletClass());
                this.servlet = (Servlet)servletClass.newInstance();
            }
            this.servlet.init(this);
        }
        catch (ServletException e) {
            this.state = 3;
            this.servlet = null;
            throw e;
        }
        catch (Throwable e) {
            this.state = 3;
            this.servlet = null;
            throw new ServletException("Unable to create servlet", e);
        }
        finally {
            this.application.exit(o);
        }
    }

    public synchronized void destroy() {
        if (this.state == 1) {
            this.state = 2;
            this.logger.debug("Stop servlet '{}'", (Object)this.getServletName());
            this.doDestroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDestroy() {
        Object o = null;
        try {
            o = this.application.enter();
            if (this.servlet != null) {
                this.servlet.destroy();
                this.servlet = null;
            }
        }
        finally {
            this.application.exit(o);
        }
    }

    public Servlet getServlet() throws ServletException {
        if (this.state == 0) {
            this.init();
        }
        return this.servlet;
    }

    public void setJspServlet(boolean jspServlet) {
        this.isJspServlet = jspServlet;
    }

    public ServletContext getServletContext() {
        return this.application;
    }

    public String getInitParameter(String name) {
        Param initParam = this.config.getInitParam(name);
        if (initParam != null) {
            return initParam.getParamValue();
        }
        return null;
    }

    public Enumeration getInitParameterNames() {
        return new IteratorEnumeration(this.config.initParamNames());
    }

    public String getServletName() {
        return this.config.getServletName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(ServletRequest req, ServletResponse res) throws IOException, ServletException {
        Object old1 = null;
        Object old2 = null;
        if (this.isJspServlet) {
            old1 = req.getAttribute(JSP_FILE);
            req.setAttribute(JSP_FILE, null);
            old2 = req.getAttribute(SERVLET_CONFIG);
            req.setAttribute(SERVLET_CONFIG, null);
        }
        try {
            this.servlet.service(req, res);
            if (this.isJspServlet) {
                req.setAttribute(SERVLET_CONFIG, old2);
                req.setAttribute(JSP_FILE, old1);
            }
        }
        catch (Throwable throwable) {
            if (this.isJspServlet) {
                req.setAttribute(SERVLET_CONFIG, old2);
                req.setAttribute(JSP_FILE, old1);
            }
            throw throwable;
        }
    }
}

