/*
 * Decompiled with CFR 0.152.
 */
package com.day.j2ee.servletengine;

import com.day.j2ee.servletengine.Constants;
import com.day.j2ee.servletengine.RequestURL;

class URLPath
implements Constants {
    private final RequestURL requestURL;
    private int parsingIndex;
    private String contextPath;
    private String servletPath;

    public URLPath(String s) {
        this.requestURL = new RequestURL(s);
    }

    public URLPath(String contextPath, String relativePath) {
        this.requestURL = new RequestURL(contextPath + relativePath);
        this.setContextPath(contextPath);
    }

    public String getRemaining() {
        String decodedRequestURI = this.requestURL.getDecodedRequestURI();
        return decodedRequestURI.substring(this.parsingIndex);
    }

    public void consume(int len) {
        String decodedRequestURI = this.requestURL.getDecodedRequestURI();
        if (this.contextPath == null) {
            this.setContextPath(decodedRequestURI.substring(this.parsingIndex, this.parsingIndex + len));
        } else if (this.servletPath == null) {
            this.setServletPath(decodedRequestURI.substring(this.parsingIndex, this.parsingIndex + len));
        }
    }

    public void setContextPath(String contextPath) {
        this.contextPath = contextPath;
        this.parsingIndex += contextPath.length();
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
        this.parsingIndex += servletPath.length();
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getPathInfo() {
        String decodedRequestURI = this.requestURL.getDecodedRequestURI();
        if (this.parsingIndex < decodedRequestURI.length()) {
            return decodedRequestURI.substring(this.parsingIndex);
        }
        return null;
    }

    public String getQueryString() {
        return this.requestURL.getQueryString();
    }

    public String getPathSessionId() {
        return this.requestURL.getSessionId();
    }

    public String getExtension() {
        return this.requestURL.getExtension();
    }

    public String getRequestURI() {
        return this.requestURL.getRequestURI();
    }

    public String getRelativePath() {
        String relativePath = this.getServletPath();
        String pathInfo = this.getPathInfo();
        if (pathInfo != null) {
            relativePath = relativePath + pathInfo;
        }
        return relativePath;
    }
}

