/*
 * Decompiled with CFR 0.152.
 */
package com.day.util;

public final class Counter {
    private int counter;
    private final boolean alertable;

    public Counter() {
        this(true);
    }

    public Counter(boolean alertable) {
        this.alertable = alertable;
    }

    public final synchronized void increment() {
        ++this.counter;
        if (this.counter == 0 && this.alertable) {
            this.notifyAll();
        }
    }

    public final synchronized void decrement() {
        if (this.counter > 0) {
            --this.counter;
            if (this.counter == 0 && this.alertable) {
                this.notifyAll();
            }
        }
    }

    public final int counter() {
        return this.counter;
    }

    public final synchronized void waitUntilZero() throws InterruptedException {
        if (!this.alertable) {
            throw new IllegalStateException("not alertable");
        }
        while (this.counter != 0) {
            this.wait();
        }
    }
}

