/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.rulebook.lang;

import com.deliveredtechnologies.rulebook.lang.RuleBookAddRuleBuilder;
import com.deliveredtechnologies.rulebook.lang.RuleBookRuleBuilder;
import com.deliveredtechnologies.rulebook.lang.RuleBookWithResultTypeBuilder;
import com.deliveredtechnologies.rulebook.lang.TerminatingRuleBookBuilder;
import com.deliveredtechnologies.rulebook.model.Rule;
import com.deliveredtechnologies.rulebook.model.RuleBook;
import com.deliveredtechnologies.rulebook.model.RuleBookAuditor;
import com.deliveredtechnologies.rulebook.model.rulechain.cor.CoRRuleBook;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleBookBuilder<T>
implements TerminatingRuleBookBuilder<T> {
    private static Logger LOGGER = LoggerFactory.getLogger(RuleBookBuilder.class);
    private RuleBook<T> _ruleBook;
    private Class<? extends RuleBook> _ruleBookClass;
    private Class<?> _resultType = Object.class;

    public static RuleBookBuilder<Object> create() {
        return new RuleBookBuilder<Object>(CoRRuleBook.class);
    }

    public static RuleBookBuilder<Object> create(Class<? extends RuleBook> ruleBookClass) {
        return new RuleBookBuilder<Object>(ruleBookClass);
    }

    private RuleBookBuilder(Class<? extends RuleBook> ruleBookClass) {
        this._ruleBookClass = ruleBookClass;
    }

    private RuleBookBuilder(RuleBookBuilder ruleBookBuilder) {
        this._resultType = ruleBookBuilder._resultType;
        this._ruleBookClass = ruleBookBuilder._ruleBookClass;
        this.newRuleBook();
    }

    public RuleBookAddRuleBuilder<T> asAuditor() {
        return new RuleBookAddRuleBuilder<T>(new RuleBookAuditor<T>(this.newRuleBook()));
    }

    public <U> RuleBookWithResultTypeBuilder<U> withResultType(Class<U> resultType) {
        this._resultType = resultType;
        return new RuleBookWithResultTypeBuilder<T>(super.newRuleBook());
    }

    public RuleBookAddRuleBuilder<T> addRule(Consumer<RuleBookRuleBuilder<T>> consumer) {
        return new RuleBookAddRuleBuilder<T>(this.newRuleBook(), consumer);
    }

    public <U> RuleBookAddRuleBuilder<T> addRule(Rule<U, T> rule) {
        return new RuleBookAddRuleBuilder<T>(this.newRuleBook(), rule);
    }

    @Override
    public RuleBook<T> build() {
        return super.newRuleBook();
    }

    private RuleBook<T> newRuleBook() {
        if (this._ruleBook == null) {
            try {
                this._ruleBook = this._ruleBookClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                try {
                    Constructor<? extends RuleBook> constructor = this._ruleBookClass.getConstructor(Class.class);
                    this._ruleBook = constructor.newInstance(this._resultType);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
                    throw new IllegalStateException("RuleBook of class " + this._ruleBookClass + " can not be instantiated", ex);
                }
            }
        }
        return this._ruleBook;
    }
}

