/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.rulebook.model.runner;

import com.deliveredtechnologies.rulebook.Result;
import com.deliveredtechnologies.rulebook.annotation.Rule;
import com.deliveredtechnologies.rulebook.model.RuleBook;
import com.deliveredtechnologies.rulebook.model.rulechain.cor.CoRRuleBook;
import com.deliveredtechnologies.rulebook.model.runner.AbstractRuleBookRunner;
import com.deliveredtechnologies.rulebook.util.AnnotationUtils;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RuleBookRunner
extends AbstractRuleBookRunner {
    private static Logger LOGGER = LoggerFactory.getLogger(RuleBookRunner.class);
    private String _package;
    private Class<? extends RuleBook> _prototypeClass;
    private Result _result = new Result<Object>(null);

    public RuleBookRunner(String rulePackage) {
        this(CoRRuleBook.class, rulePackage);
    }

    public RuleBookRunner(Class<? extends RuleBook> ruleBookClass, String rulePackage) {
        super(ruleBookClass);
        this._prototypeClass = ruleBookClass;
        this._package = rulePackage;
    }

    @Override
    protected List<Class<?>> getPojoRules() {
        Reflections reflections = new Reflections(this._package, new Scanner[0]);
        List<Class<?>> rules = reflections.getTypesAnnotatedWith(Rule.class).stream().filter(rule -> this._package.equals(rule.getPackage().getName())).filter(rule -> rule.getAnnotatedSuperclass() != null).collect(Collectors.toList());
        rules.sort(Comparator.comparingInt(aClass -> AnnotationUtils.getAnnotation(Rule.class, aClass).order()));
        return rules;
    }
}

