/*
 * Decompiled with CFR 0.152.
 */
package com.deliveredtechnologies.rulebook.runner;

import com.deliveredtechnologies.rulebook.Decision;
import com.deliveredtechnologies.rulebook.Fact;
import com.deliveredtechnologies.rulebook.FactMap;
import com.deliveredtechnologies.rulebook.Result;
import com.deliveredtechnologies.rulebook.Rule;
import com.deliveredtechnologies.rulebook.RuleState;
import com.deliveredtechnologies.rulebook.StandardRule;
import com.deliveredtechnologies.rulebook.annotation.Given;
import com.deliveredtechnologies.rulebook.annotation.Then;
import com.deliveredtechnologies.rulebook.annotation.When;
import com.deliveredtechnologies.rulebook.util.AnnotationUtils;
import java.io.InvalidClassException;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public class RuleAdapter
implements Decision {
    private static Logger LOGGER = LoggerFactory.getLogger(RuleAdapter.class);
    private Object _rulePojo;
    private Rule _rule;
    private Result _result = new Result();

    public RuleAdapter(Object rulePojo, Rule rule) throws InvalidClassException {
        if (AnnotationUtils.getAnnotation(com.deliveredtechnologies.rulebook.annotation.Rule.class, rulePojo.getClass()) == null) {
            throw new InvalidClassException(rulePojo.getClass() + " is not a Rule; missing @Rule annotation");
        }
        this._rule = rule;
        this._rulePojo = rulePojo;
    }

    public RuleAdapter(Object rulePojo) throws InvalidClassException {
        this(rulePojo, new StandardRule<Object>(Object.class));
    }

    @Override
    public Decision given(Fact ... facts) {
        this._rule.given(facts);
        this.mapGivenFactsToProperties();
        return this;
    }

    @Override
    public Decision given(List list) {
        this._rule.given(list);
        this.mapGivenFactsToProperties();
        return this;
    }

    @Override
    public Decision given(FactMap facts) {
        this._rule.given(facts);
        this.mapGivenFactsToProperties();
        return this;
    }

    @Override
    public Decision given(String name, Object value) {
        this._rule.given(name, value);
        this.mapGivenFactsToProperties();
        return this;
    }

    @Override
    public Decision givenUnTyped(FactMap facts) {
        this._rule.givenUnTyped(facts);
        this.mapGivenFactsToProperties();
        return this;
    }

    @Override
    public Predicate getWhen() {
        if (this._rule.getWhen() != null) {
            return this._rule.getWhen();
        }
        return Arrays.stream(this._rulePojo.getClass().getMethods()).filter(method -> method.getReturnType() == Boolean.TYPE || method.getReturnType() == Boolean.class).filter(method -> Arrays.stream(method.getDeclaredAnnotations()).anyMatch(When.class::isInstance)).findFirst().map(method -> object -> {
            try {
                return (Boolean)method.invoke(this._rulePojo, new Object[0]);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                LOGGER.error("Unable to validate condition due to an exception. Condition will be interpreted as false", (Throwable)ex);
                return false;
            }
        }).orElse(o -> false);
    }

    @Override
    public List<Object> getThen() {
        if (this._rule.getThen().size() < 1) {
            ArrayList<Consumer<Object>> thenList = new ArrayList<Consumer<Object>>();
            for (Method thenMethod : AnnotationUtils.getAnnotatedMethods(Then.class, this._rulePojo.getClass())) {
                thenMethod.setAccessible(true);
                Consumer<Object> then = this.getThenMethodAsBiConsumer(thenMethod).map(Object.class::cast).orElse(this.getThenMethodAsConsumer(thenMethod).orElse(factMap -> {}));
                thenList.add(then);
            }
            this._rule.getThen().addAll(thenList);
        }
        return this._rule.getThen();
    }

    @Override
    public void run(Object ... otherArgs) {
        this.getThen();
        this._rule.run(this._result);
    }

    @Override
    public Decision when(Predicate test) {
        this._rule.when(test);
        return this;
    }

    @Override
    public Decision then(Consumer action) {
        this._rule.then(action);
        return this;
    }

    public Decision then(BiConsumer action) {
        this._rule.getThen().add(action);
        return this;
    }

    @Override
    public Decision using(String ... factName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Decision stop() {
        this._rule.stop();
        return this;
    }

    public Object getResult() {
        return this._result.getValue();
    }

    public void setResult(Result result) {
        this._result = result;
    }

    @Override
    public FactMap getFactMap() {
        return this._rule.getFactMap();
    }

    @Override
    public void setNextRule(Rule rule) {
        this._rule.setNextRule(rule);
    }

    private void mapGivenFactsToProperties() {
        for (Field field : AnnotationUtils.getAnnotatedFields(Given.class, this._rulePojo.getClass())) {
            Given given = field.getAnnotation(Given.class);
            try {
                field.setAccessible(true);
                if (field.getType() == Fact.class) {
                    field.set(this._rulePojo, this.getFactMap().get(given.value()));
                    continue;
                }
                Object value = this.getFactMap().getValue(given.value());
                if (value != null) {
                    field.set(this._rulePojo, value);
                    continue;
                }
                if (FactMap.class == field.getType()) {
                    field.set(this._rulePojo, this.getFactMap());
                    continue;
                }
                if (Collection.class.isAssignableFrom(field.getType())) {
                    Stream<Object> stream = this.getFactMap().values().stream().filter(fact -> {
                        ParameterizedType paramType = (ParameterizedType)field.getGenericType();
                        Class genericType = (Class)paramType.getActualTypeArguments()[0];
                        return genericType.equals(((Fact)fact).getValue().getClass());
                    }).map(fact -> {
                        ParameterizedType paramType = (ParameterizedType)field.getGenericType();
                        Class genericType = (Class)paramType.getActualTypeArguments()[0];
                        return genericType.cast(((Fact)fact).getValue());
                    });
                    if (List.class == field.getType()) {
                        field.set(this._rulePojo, stream.collect(Collectors.toList()));
                        continue;
                    }
                    if (Set.class != field.getType()) continue;
                    field.set(this._rulePojo, stream.collect(Collectors.toSet()));
                    continue;
                }
                if (Map.class != field.getType()) continue;
                Map<Object, Object> map = this.getFactMap().keySet().stream().filter(key -> {
                    ParameterizedType paramType = (ParameterizedType)field.getGenericType();
                    Class genericType = (Class)paramType.getActualTypeArguments()[1];
                    return genericType.equals(this.getFactMap().getValue((String)key).getClass());
                }).collect(Collectors.toMap(key -> key, key -> this.getFactMap().getValue((String)key)));
                field.set(this._rulePojo, map);
            }
            catch (Exception ex) {
                LOGGER.error("Unable to update field '" + field.getName() + "' in rule object '" + this._rulePojo.getClass() + "'", (Throwable)ex);
            }
        }
    }

    private Optional<BiConsumer> getThenMethodAsBiConsumer(Method method) {
        return AnnotationUtils.getAnnotatedField(com.deliveredtechnologies.rulebook.annotation.Result.class, this._rulePojo.getClass()).map(resultField -> (facts, result) -> {
            try {
                Object retVal = method.invoke(this._rulePojo, new Object[0]);
                if (method.getReturnType() == RuleState.class && retVal == RuleState.BREAK) {
                    this.stop();
                }
                resultField.setAccessible(true);
                Object resultVal = resultField.get(this._rulePojo);
                ((Result)result).setValue(resultVal);
            }
            catch (IllegalAccessException | InvocationTargetException ex) {
                LOGGER.error("Unable to access " + this._rulePojo.getClass().getName() + " when converting then to BiConsumer", (Throwable)ex);
            }
        });
    }

    private Optional<Consumer> getThenMethodAsConsumer(Method method) {
        if (!AnnotationUtils.getAnnotatedField(com.deliveredtechnologies.rulebook.annotation.Result.class, this._rulePojo.getClass()).isPresent()) {
            return Optional.of(obj -> {
                try {
                    Object retVal = method.invoke(this._rulePojo, new Object[0]);
                    if (method.getReturnType() == RuleState.class && retVal == RuleState.BREAK) {
                        this.stop();
                    }
                }
                catch (IllegalAccessException | InvocationTargetException ex) {
                    LOGGER.error("Unable to access " + this._rulePojo.getClass().getName() + " when converting then to Consumer", (Throwable)ex);
                }
            });
        }
        return Optional.empty();
    }
}

