/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javascript.archive;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.jar.JarArchiver;
import org.codehaus.plexus.archiver.jar.Manifest;
import org.codehaus.plexus.archiver.jar.ManifestException;

public class JavascriptArchiver
extends JarArchiver {
    public JavascriptArchiver() {
        this.archiveType = "jar";
    }

    public void createDefaultManifest(MavenProject project) throws ManifestException, IOException, ArchiverException {
        Manifest manifest = new Manifest();
        Manifest.Attribute attr = new Manifest.Attribute("Created-By", "Apache Maven");
        manifest.addConfiguredAttribute(attr);
        attr = new Manifest.Attribute("Implementation-Title", project.getName());
        manifest.addConfiguredAttribute(attr);
        attr = new Manifest.Attribute("Implementation-Version", project.getVersion());
        manifest.addConfiguredAttribute(attr);
        attr = new Manifest.Attribute("Implementation-Vendor-Id", project.getGroupId());
        manifest.addConfiguredAttribute(attr);
        if (project.getOrganization() != null) {
            String vendor = project.getOrganization().getName();
            attr = new Manifest.Attribute("Implementation-Vendor", vendor);
            manifest.addConfiguredAttribute(attr);
        }
        attr = new Manifest.Attribute("Built-By", System.getProperty("user.name"));
        manifest.addConfiguredAttribute(attr);
        File mf = File.createTempFile("maven", ".mf");
        mf.deleteOnExit();
        PrintWriter writer = new PrintWriter(new FileWriter(mf));
        manifest.write(writer);
        writer.close();
        this.setManifest(mf);
    }
}

