/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.javascript.archive;

import java.io.File;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public class JavascriptArtifactManager
extends AbstractLogEnabled {
    private UnArchiver archiver;

    public void unpack(MavenProject project, String scope, File target, boolean useArtifactId) throws ArchiverException {
        this.archiver.setOverwrite(false);
        Set dependencies = project.getArtifacts();
        ScopeArtifactFilter runtime = new ScopeArtifactFilter(scope);
        for (Artifact dependency : dependencies) {
            if (dependency.isOptional() || !"javascript".equals(dependency.getType()) || !runtime.include(dependency)) continue;
            this.getLogger().info("Unpack javascript dependency [" + dependency.toString() + "]");
            this.archiver.setSourceFile(dependency.getFile());
            this.unpack(dependency, target, useArtifactId);
        }
    }

    public void unpack(Artifact artifact, File target) throws ArchiverException {
        this.unpack(artifact, target, false);
    }

    public void unpack(Artifact artifact, File target, boolean useArtifactId) throws ArchiverException {
        this.archiver.setSourceFile(artifact.getFile());
        this.archiver.setOverwrite(false);
        try {
            File dest = target;
            if (useArtifactId) {
                dest = new File(target, artifact.getArtifactId());
            }
            dest.mkdirs();
            this.archiver.setDestDirectory(dest);
            this.archiver.extract();
        }
        catch (Exception e) {
            throw new ArchiverException("Failed to extract javascript artifact to " + target, (Throwable)e);
        }
    }
}

