/**
 * Copyright 2015 DiffPlug
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.diffplug.common.base;

import java.util.stream.Stream;
import java.util.stream.StreamSupport;

/** Methods which create a Stream<T> which walks a tree structure. */
public class TreeStream {
	private TreeStream() {}

	/** Creates a Stream<T> towards the parent. */
	public static <T> Stream<T> toParent(TreeDef.Parented<T> treeDef, T node) {
		return StreamSupport.stream(TreeIterable.toParent(treeDef, node).spliterator(), false);
	}

	/** Creates a Stream<T> doing a breadth-first iteration. */
	public static <T> Stream<T> breadthFirst(TreeDef<T> treeDef, T node) {
		return StreamSupport.stream(TreeIterable.breadthFirst(treeDef, node).spliterator(), false);
	}

	/** Creates a Stream<T> doing a depth-first iteration. */
	public static <T> Stream<T> depthFirst(TreeDef<T> treeDef, T node) {
		return StreamSupport.stream(TreeIterable.depthFirst(treeDef, node).spliterator(), false);
	}
}
