/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.common.swt.os;

import com.diffplug.common.swt.os.Arch;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;
import java.util.function.Function;

public enum OS {
    WIN_x64,
    WIN_x86,
    LINUX_x64,
    LINUX_x86,
    MAC_x64,
    MAC_silicon;

    private static OS NATIVE_OS;
    private static OS RUNNING_OS;

    public boolean isWindows() {
        return this == WIN_x64 || this == WIN_x86;
    }

    public boolean isLinux() {
        return this == LINUX_x64 || this == LINUX_x86;
    }

    public boolean isMac() {
        return this == MAC_x64 || this == MAC_silicon;
    }

    public boolean isMacOrLinux() {
        return this.isMac() || this.isLinux();
    }

    public <T> T winMacLinux(T win, T mac, T linux) {
        if (this.isWindows()) {
            return win;
        }
        if (this.isMac()) {
            return mac;
        }
        if (this.isLinux()) {
            return linux;
        }
        throw OS.unsupportedException(this);
    }

    public Arch getArch() {
        switch (this) {
            case WIN_x64: 
            case LINUX_x64: 
            case MAC_x64: {
                return Arch.x64;
            }
            case WIN_x86: 
            case LINUX_x86: {
                return Arch.x86;
            }
            case MAC_silicon: {
                return Arch.arm64;
            }
        }
        throw OS.unsupportedException(this);
    }

    public String os() {
        return this.winMacLinux("win32", "linux", "macosx");
    }

    public String arch() {
        return this.getArch().x86x64arm64("x86", "x86_64", "aarch64");
    }

    public String osDotArch() {
        return this.os() + "." + this.arch();
    }

    public String toSwt() {
        return this.winMacLinux("win32", "cocoa", "gtk") + "." + this.winMacLinux("win32", "macosx", "linux") + "." + this.getArch().x86x64arm64("x86", "x86_64", "aarch64");
    }

    public static OS getNative() {
        OS.detectPlatform();
        return NATIVE_OS;
    }

    public static OS getRunning() {
        OS.detectPlatform();
        return RUNNING_OS;
    }

    public static void detectPlatform(Function<String, String> systemProperty, Function<String, String> environmentVariable) {
        if (NATIVE_OS == null) {
            NATIVE_OS = OS.calculateNative(systemProperty, environmentVariable);
            RUNNING_OS = OS.calculateRunning(systemProperty);
        }
    }

    private static void detectPlatform() {
        if (NATIVE_OS == null) {
            OS.detectPlatform(System::getProperty, System::getenv);
        }
    }

    private static OS calculateNative(Function<String, String> systemProperty, Function<String, String> environmentVariable) {
        String os_name = systemProperty.apply("os.name").toLowerCase(Locale.getDefault());
        boolean isWin = os_name.contains("win");
        boolean isMac = os_name.contains("mac");
        boolean isLinux = Arrays.asList("nix", "nux", "aix").stream().anyMatch(os_name::contains);
        if (isMac) {
            return OS.exec("uname", "-a").contains("_ARM64_") ? MAC_silicon : MAC_x64;
        }
        if (isWin) {
            boolean is64bit = environmentVariable.apply("ProgramFiles(x86)") != null;
            return is64bit ? WIN_x64 : WIN_x86;
        }
        if (isLinux) {
            String os_arch;
            switch (os_arch = systemProperty.apply("os.arch")) {
                case "i386": 
                case "x86": {
                    return LINUX_x86;
                }
                case "x86_64": 
                case "amd64": {
                    return LINUX_x64;
                }
            }
            throw new IllegalArgumentException("Unknown os.arch " + os_arch + "'.");
        }
        throw new IllegalArgumentException("Unknown os.name '" + os_name + "'.");
    }

    private static String exec(String ... cmd) {
        try {
            Process process = Runtime.getRuntime().exec(new String[]{"uname", "-a"});
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            OS.drain(process.getInputStream(), output);
            return new String(output.toByteArray(), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static void drain(InputStream input, OutputStream output) throws IOException {
        int numRead;
        byte[] buf = new byte[1024];
        while ((numRead = input.read(buf)) != -1) {
            output.write(buf, 0, numRead);
        }
    }

    private static OS calculateRunning(Function<String, String> systemProperty) {
        Arch runningArch = OS.runningJvm(systemProperty);
        OS runningOs = NATIVE_OS.winMacLinux(runningArch.x86x64arm64(WIN_x86, WIN_x64, null), (Object)((Object)runningArch.x86x64arm64(null, MAC_x64, MAC_silicon)), runningArch.x86x64arm64(LINUX_x86, LINUX_x64, null));
        if (runningOs == null) {
            throw new IllegalArgumentException("Unsupported OS/Arch combo: " + (Object)((Object)runningOs) + " " + (Object)((Object)runningArch));
        }
        return runningOs;
    }

    private static Arch runningJvm(Function<String, String> systemProperty) {
        String sunArchDataModel;
        switch (sunArchDataModel = systemProperty.apply("sun.arch.data.model")) {
            case "32": {
                return Arch.x86;
            }
            case "64": {
                return "aarch64".equals(systemProperty.apply("os.arch")) ? Arch.arm64 : Arch.x64;
            }
        }
        throw new IllegalArgumentException("Expcted 32 or 64, was " + sunArchDataModel);
    }

    public static UnsupportedOperationException unsupportedException(OS os) {
        return new UnsupportedOperationException("Operating system '" + (Object)((Object)os) + "' is not supported.");
    }

    public static void main(String[] args) {
        System.out.println("native=" + (Object)((Object)OS.getNative()));
        System.out.println("running=" + (Object)((Object)OS.getRunning()));
    }
}

