/*
 * Decompiled with CFR 0.152.
 */
package com.dimajix.flowman.maven.fs;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystemNotFoundException;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public interface FileSystem {
    public static List<FileSystem> getFileSystems() {
        ServiceLoader<FileSystem> loader = ServiceLoader.load(FileSystem.class);
        return StreamSupport.stream(loader.spliterator(), false).collect(Collectors.toList());
    }

    public static FileSystem getFileSystem(URI uri) {
        return FileSystem.getFileSystem(uri.getScheme());
    }

    public static FileSystem getFileSystem(String scheme) {
        String fscheme = scheme != null ? scheme : "file";
        ServiceLoader<FileSystem> loader = ServiceLoader.load(FileSystem.class);
        return StreamSupport.stream(loader.spliterator(), false).filter(fs -> fs.getScheme().equals(fscheme)).findFirst().orElseThrow(() -> new FileSystemNotFoundException("No filesystem for scheme '" + scheme + "'"));
    }

    public String getScheme();

    public void put(URI var1, File var2) throws IOException;

    public void putAll(URI var1, File var2) throws IOException;

    public void delete(URI var1, boolean var2) throws IOException;
}

