/*
 * Decompiled with CFR 0.152.
 */
package com.dimajix.flowman.maven.fs;

import com.dimajix.flowman.maven.fs.FileSystem;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;

public class LocalFileSystem
implements FileSystem {
    @Override
    public String getScheme() {
        return "file";
    }

    @Override
    public void put(URI target, File source) throws IOException {
        Path path = Paths.get(this.normalizeUri(target));
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Files.copy(source.toPath(), path, StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public void putAll(URI target, File sources) throws IOException {
        Path path = Paths.get(this.normalizeUri(target));
        Files.createDirectories(path, new FileAttribute[0]);
        for (Path src : Files.list(sources.toPath()).collect(Collectors.toList())) {
            Path tgt = path.resolve(src.getFileName().toString());
            if (Files.isDirectory(src, new LinkOption[0])) {
                this.putAll(tgt.toUri(), src.toFile());
                continue;
            }
            Files.copy(src, tgt, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    @Override
    public void delete(URI target, boolean recursive) throws IOException {
        Path path = Paths.get(this.normalizeUri(target));
        if (Files.exists(path, new LinkOption[0])) {
            if (Files.isDirectory(path, new LinkOption[0]) && recursive) {
                for (Path src : Files.list(path).collect(Collectors.toList())) {
                    this.delete(src.toUri(), recursive);
                }
            }
            Files.delete(path);
        }
    }

    private URI normalizeUri(URI uri) throws IOException {
        try {
            return uri.getScheme() == null ? new URI("file:" + uri) : uri;
        }
        catch (URISyntaxException ex) {
            throw new IOException(ex);
        }
    }
}

