/*
 * Decompiled with CFR 0.152.
 */
package com.dimajix.flowman.maven.plugin.impl;

import com.dimajix.flowman.maven.plugin.model.BuildSettings;
import com.dimajix.flowman.maven.plugin.model.ExecutionSettings;
import com.dimajix.flowman.maven.plugin.model.FlowmanSettings;
import com.dimajix.flowman.maven.plugin.model.Package;
import com.dimajix.flowman.maven.plugin.mojos.FlowmanMojo;
import com.dimajix.flowman.maven.plugin.util.Collections;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;

public abstract class AbstractPackage
extends Package {
    @JsonIgnore
    protected FlowmanMojo mojo;
    @JsonIgnore
    protected Log log;

    @Override
    public void init(FlowmanMojo mojo) {
        this.mojo = mojo;
        this.log = mojo.getLog();
    }

    @Override
    public Artifact getArtifact() {
        MavenProject mavenProject = this.mojo.getMavenProject();
        Artifact projectArtifact = mavenProject.getArtifact();
        ArtifactHandler artifactHandler = this.mojo.getArtifactHandlerManager().getArtifactHandler(this.getType());
        return new DefaultArtifact(projectArtifact.getGroupId(), projectArtifact.getArtifactId(), projectArtifact.getVersion(), null, this.getType(), this.getName(), artifactHandler);
    }

    @Override
    public FlowmanSettings getEffectiveFlowmanSettings() throws MojoFailureException {
        FlowmanSettings descriptorSettings = this.mojo.getDescriptor().getFlowmanSettings();
        FlowmanSettings result = new FlowmanSettings();
        result.setVersion(StringUtils.isNotEmpty((CharSequence)this.flowmanSettings.getVersion()) ? this.flowmanSettings.getVersion() : descriptorSettings.getVersion());
        result.setPlugins(Collections.concat(descriptorSettings.getPlugins(), this.flowmanSettings.getPlugins()));
        result.setEnvironment(Collections.concat(descriptorSettings.getEnvironment(), this.flowmanSettings.getEnvironment()));
        result.setConfig(Collections.concat(descriptorSettings.getConfig(), this.flowmanSettings.getConfig()));
        return result;
    }

    @Override
    public BuildSettings getEffectiveBuildSettings() throws MojoFailureException {
        BuildSettings descriptorSettings = this.mojo.getDescriptor().getBuildSettings();
        BuildSettings result = new BuildSettings();
        result.setProperties(Collections.concat(descriptorSettings.getProperties(), this.buildSettings.getProperties()));
        result.setDependencies(Collections.concat(descriptorSettings.getDependencies(), this.buildSettings.getDependencies()));
        result.setExclusions(Collections.concat(descriptorSettings.getExclusions(), this.buildSettings.getExclusions()));
        return result;
    }

    @Override
    public ExecutionSettings getEffectiveExecutionSettings() throws MojoFailureException {
        ExecutionSettings descriptorSettings = this.mojo.getDescriptor().getExecutionSettings();
        ExecutionSettings result = new ExecutionSettings();
        result.setEnvironment(Collections.concat(descriptorSettings.getEnvironment(), this.executionSettings.getEnvironment()));
        result.setConfig(Collections.concat(descriptorSettings.getConfig(), this.executionSettings.getConfig()));
        result.setProfiles(Collections.concat(descriptorSettings.getProfiles(), this.executionSettings.getProfiles()));
        result.setSystemEnvironment(Collections.concat(descriptorSettings.getSystemEnvironment(), this.executionSettings.getSystemEnvironment()));
        result.setJavaOptions(Collections.concat(descriptorSettings.getJavaOptions(), this.executionSettings.getJavaOptions()));
        result.setFlowmanOptions(Collections.concat(descriptorSettings.getFlowmanOptions(), this.executionSettings.getFlowmanOptions()));
        return result;
    }

    protected File getBuildDirectory() {
        return new File(this.mojo.getCurrentMavenProject().getBuild().getDirectory());
    }

    protected File getOutputDirectory() {
        return new File(this.mojo.getCurrentMavenProject().getBuild().getOutputDirectory());
    }

    protected Dependency toDependency(Artifact artifact) {
        Dependency dep = new Dependency();
        dep.setGroupId(artifact.getGroupId());
        dep.setArtifactId(artifact.getArtifactId());
        dep.setVersion(artifact.getVersion());
        dep.setType(artifact.getType());
        dep.setScope(artifact.getScope());
        return dep;
    }

    protected List<Dependency> toDependencies(Artifact ... artifacts) {
        return this.toDependencies(Arrays.asList(artifacts));
    }

    protected List<Dependency> toDependencies(List<Artifact> artifacts) {
        return artifacts.stream().map(this::toDependency).collect(Collectors.toList());
    }
}

