/*
 * Decompiled with CFR 0.152.
 */
package com.dimajix.flowman.maven.plugin.impl;

import com.dimajix.flowman.maven.plugin.impl.AbstractPackage;
import com.dimajix.flowman.maven.plugin.model.FlowmanSettings;
import com.dimajix.flowman.maven.plugin.tasks.AssembleDist;
import com.dimajix.flowman.maven.plugin.tasks.ProcessResources;
import com.dimajix.flowman.maven.plugin.tasks.RunArtifacts;
import com.dimajix.flowman.maven.plugin.tasks.UnpackDependencies;
import com.dimajix.flowman.maven.plugin.tasks.assembly.AssemblyDescriptor;
import com.dimajix.flowman.maven.plugin.tasks.assembly.FileSet;
import com.dimajix.flowman.maven.plugin.util.Jackson;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;

public class DistPackage
extends AbstractPackage {
    @JsonProperty(value="baseDirectory", required=false)
    private String baseDirectory;

    @Override
    public String getType() {
        return "tar.gz";
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void build() throws MojoFailureException, MojoExecutionException {
        flowmanSettings = this.getEffectiveFlowmanSettings();
        mavenProject = this.mojo.getCurrentMavenProject();
        buildDirectory = this.getBuildDirectory();
        outputDirectory = this.getOutputDirectory();
        dist = flowmanSettings.resolveDist();
        unpack = new UnpackDependencies(this.mojo, mavenProject);
        unpack.unpack(Collections.singletonList(dist), buildDirectory);
        plugins = flowmanSettings.resolvePluginDists();
        if (!plugins.isEmpty()) {
            unpack.unpack(plugins, new File(buildDirectory, "flowman-" + flowmanSettings.getVersion()));
        }
        resources = new ProcessResources(this.mojo, mavenProject);
        resources.processResources(this.mojo.getDescriptor().getProjects(), outputDirectory);
        resources.processResources(this.mojo.getDescriptor().getResources(), outputDirectory);
        resources.processResources(new File("conf"), outputDirectory);
        ns = new File(outputDirectory, "conf/default-namespace.yml");
        try {
            mapper = new ObjectMapper((JsonFactory)Jackson.newYAMLFactory());
            objectTree = null;
            if (ns.exists() && ns.isFile()) {
                reader = new FileInputStream(ns);
                try {
                    tree = mapper.reader().readTree((InputStream)reader);
                    if (!tree.isObject()) ** GOTO lbl31
                    objectTree = (ObjectNode)tree;
                }
                finally {
                    reader.close();
                }
            } else {
                ns.getParentFile().mkdirs();
            }
lbl31:
            // 3 sources

            if (objectTree == null) {
                objectTree = mapper.getNodeFactory().objectNode();
                objectTree.put("name", "default");
            }
            configValues = flowmanSettings.getConfig();
            Jackson.mergeArray((JsonNode)objectTree, "config", configValues);
            envValues = flowmanSettings.getEnvironment();
            Jackson.mergeArray((JsonNode)objectTree, "environment", envValues);
            pluginNames = flowmanSettings.getPlugins().stream().filter((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$build$0(java.lang.String ), (Ljava/lang/String;)Z)()).collect(Collectors.toList());
            Jackson.mergeArray((JsonNode)objectTree, "plugins", pluginNames);
            mapper.writer().writeValue(ns, (Object)objectTree);
        }
        catch (IOException ex) {
            throw new MojoFailureException("Error processing '" + ns + "'", (Throwable)ex);
        }
    }

    @Override
    public void test(File project) throws MojoFailureException, MojoExecutionException {
        FlowmanSettings flowmanSettings = this.getEffectiveFlowmanSettings();
        MavenProject mavenProject = this.mojo.getCurrentMavenProject();
        File buildDirectory = this.getBuildDirectory();
        File outputDirectory = this.getOutputDirectory();
        File confDirectory = new File(outputDirectory, "conf");
        File homeDirectory = new File(buildDirectory, "flowman-" + flowmanSettings.getVersion());
        List<File> projectDirectories = project != null ? Collections.singletonList(project) : this.mojo.getDescriptor().getProjects();
        RunArtifacts run = new RunArtifacts(this.mojo, mavenProject, homeDirectory, confDirectory, this.getEffectiveExecutionSettings());
        for (File flow : projectDirectories) {
            File projectDirectory = new File(outputDirectory, flow.getPath());
            run.runTests(projectDirectory);
        }
    }

    @Override
    public void pack() throws MojoFailureException, MojoExecutionException {
        FlowmanSettings flowmanSettings = this.getEffectiveFlowmanSettings();
        MavenProject mavenProject = this.mojo.getCurrentMavenProject();
        File buildDirectory = this.getBuildDirectory();
        File outputDirectory = this.getOutputDirectory();
        File confDirectory = new File(outputDirectory, "conf");
        File homeDirectory = new File(buildDirectory, "flowman-" + flowmanSettings.getVersion());
        File ns = new File(outputDirectory, "conf/default-namespace.yml");
        HashSet plugins = new HashSet();
        try {
            if (ns.exists() && ns.isFile()) {
                try (FileInputStream reader = new FileInputStream(ns);){
                    ObjectNode objectTree;
                    JsonNode pluginNode;
                    ObjectMapper mapper = new ObjectMapper((JsonFactory)Jackson.newYAMLFactory());
                    JsonNode tree = mapper.reader().readTree((InputStream)reader);
                    if (tree.isObject() && (pluginNode = (objectTree = (ObjectNode)tree).get("plugins")) != null && pluginNode.isArray()) {
                        pluginNode.forEach(n -> plugins.add(n.textValue()));
                    }
                }
            }
            flowmanSettings.getPlugins().stream().filter(p -> !p.contains(":")).forEach(plugins::add);
        }
        catch (IOException ex) {
            throw new MojoFailureException("Error parsing '" + ns + "'", (Throwable)ex);
        }
        AssemblyDescriptor descriptor = new AssemblyDescriptor();
        descriptor.setId(this.getName());
        descriptor.setFormats(Collections.singletonList("tar.gz"));
        descriptor.setBaseDirectory(this.baseDirectory != null ? this.baseDirectory : mavenProject.getArtifactId() + "-" + mavenProject.getVersion());
        LinkedList<FileSet> fileSets = new LinkedList<FileSet>();
        fileSets.add(new FileSet(homeDirectory.toString(), "", "0644", "0755", Arrays.asList("**/*"), Arrays.asList("bin/*", "conf/*", "plugins/**", "examples/**")));
        fileSets.add(new FileSet(homeDirectory.toString(), "", "0755", "0755", Arrays.asList("bin/*"), Collections.emptyList()));
        fileSets.add(new FileSet(confDirectory.toString(), "conf", "0644", "0755", Collections.emptyList(), Collections.emptyList()));
        plugins.stream().filter(p -> !p.contains(":")).forEach(plugin -> fileSets.add(new FileSet(new File(homeDirectory, "plugins/" + plugin).toString(), new File("plugins", (String)plugin).toString(), "0644", "0755", Collections.emptyList(), Collections.emptyList())));
        this.mojo.getDescriptor().getProjects().forEach(project -> fileSets.add(new FileSet(new File(outputDirectory, project.getPath()).toString(), new File("flows", project.getPath()).toString(), "0644", "0755", Collections.emptyList(), Collections.emptyList())));
        this.mojo.getDescriptor().getResources().forEach(resource -> fileSets.add(new FileSet(new File(outputDirectory, resource.getPath()).toString(), new File("flows", resource.getPath()).toString(), "0644", "0755", Collections.emptyList(), Collections.emptyList())));
        descriptor.setFileSets(fileSets);
        AssembleDist assembler = new AssembleDist(this.mojo, mavenProject);
        assembler.assemble(descriptor, mavenProject.getArtifactId() + "-" + mavenProject.getVersion());
        Artifact artifact = mavenProject.getArtifact();
        this.mojo.attachArtifact(artifact.getFile(), artifact.getType(), this.getName());
    }

    @Override
    public void shell(File project) throws MojoFailureException, MojoExecutionException {
        FlowmanSettings flowmanSettings = this.getEffectiveFlowmanSettings();
        MavenProject mavenProject = this.mojo.getCurrentMavenProject();
        File buildDirectory = new File(mavenProject.getBuild().getDirectory());
        File outputDirectory = new File(mavenProject.getBuild().getOutputDirectory());
        File projectDirectory = new File(outputDirectory, project.getPath());
        File confDirectory = new File(outputDirectory, "conf");
        File homeDirectory = new File(buildDirectory, "flowman-" + flowmanSettings.getVersion());
        RunArtifacts run = new RunArtifacts(this.mojo, mavenProject, homeDirectory, confDirectory, this.getEffectiveExecutionSettings());
        run.runShell(projectDirectory);
    }

    @Override
    public void push() throws MojoFailureException, MojoExecutionException {
    }

    @Override
    public List<Dependency> getDependencies() throws MojoFailureException {
        FlowmanSettings flowmanSettings = this.getEffectiveFlowmanSettings();
        Artifact flowmanTools = flowmanSettings.resolveTools();
        Artifact flowmanSpark = flowmanSettings.resolveSparkDependencies();
        List<Artifact> allDeps = Arrays.asList(flowmanTools, flowmanSpark);
        return this.toDependencies(allDeps);
    }

    private static /* synthetic */ boolean lambda$build$0(String p) {
        return !p.contains(":");
    }
}

